// $Id: stringparser.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "stringparser.hpp"

#include <sstream>
#include <fstream>


namespace spatter {

int
parse_int(const std::string& str)
{
    int x;
    std::istringstream is(str);
    is >> x;
    return x;
}


double
parse_double(const std::string& str)
{
    double x;
    std::istringstream is(str);
    is >> x;
    return x;
}

lti::imatrix
parse_matrix(const std::string& str, int rows, int columns)
{
    int* data = new int[rows * columns];

    for (int i = 0; str[i] && i < rows * columns; ++i) {
        data[i] = parse_int(str.substr(i, 1));
    }

    lti::imatrix mat(rows, columns, data);

    return mat;
}


lti::ubyte*
parse_int_array(const char* s, unsigned int len)
{
    std::vector< std::string > v;
    std::string cur = "";

    for (int i = 0; s[i]; ++i) {
        if (s[i] != ',') {
            cur += s[i];
        } else {
            v.push_back(cur);
            cur = "";
        }   
    }
    v.push_back(cur);

    // sanity check
    if (v.size() != len)
        return 0;

    lti::ubyte* data = new lti::ubyte[v.size()];

    for (unsigned int i = 0; i < v.size(); ++i) {
        data[i] = parse_int(v[i].c_str());
    }

    return data;
}

std::string
unparse_int(int x)
{
    std::ostringstream oss;
    oss << x;

    return oss.str();
}

std::string
unparse_double(double x)
{
    std::ostringstream oss;
    oss << x;

    return oss.str();
}

pair_string
unparse_point(lti::point point)
{
    return make_pair(unparse_int(point[0]), unparse_int(point[1]));
}

std::string
unparse_matrix(lti::imatrix mat)
{
    std::string str = "";

    for (int r = 0; r < mat.rows(); ++r) {
        for (int c = 0; c < mat.columns(); ++c) {
            str += unparse_int(mat[r][c]);
        }
    }

    return str;
}

} // namespace spatter
