// $Id$
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include <iostream>
#include <string>
#include <cstdlib>
#include <limits>

#include <ltiALLFunctor.h>
#include <ltiImage.h>
#include <ltiRGBPixel.h>

#include "spotlist.hpp"
#include "spotviewer.hpp"

static void
print_usage(int argc, char** argv)
{
    std::cout << "Usage: "
              << argv[0]
              << " imagefile spotfile spotimagefile"
              << std::endl;
}


int
main(int argc, char** argv)
{
    try {
        if (argc < 4) {
            print_usage(argc, argv);
        } else {
            std::string image_fname(argv[1]);
            std::string spot_fname(argv[2]);
            std::string spotimage_fname(argv[3]);

            lti::loadImage loader;
            lti::image img;
            loader.load(image_fname, img);

            SpotList spot_list(spot_fname.c_str());

            SpotViewer spotviewer(lti::rgbPixel(0,0,255));
            spotviewer.apply(spot_list, img);

            lti::saveImage saver;
            saver.save(spotimage_fname, img);
        }
    } catch (lti::exception& exp) {
        std::cout << "An lti::exception was thrown: ";
        std::cout << exp.what() << std::endl;
    } catch (std::exception& exp) {
        std::cout << "std::exception was thrown: ";
        std::cout << exp.what() << std::endl;
    } catch (...) {
        std::cout << "Unknown exception thrown!" << std::endl;
    }

    return 0;
}
