// $Id$
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include <iostream>
#include <string>
#include <cstdlib>
#include <limits>

#include <ltiALLFunctor.h>
#include <ltiImage.h>
#include <ltiRGBPixel.h>

#include "grid.hpp"
#include "gridviewer.hpp"

static void
print_usage(int argc, char** argv)
{
    std::cout << "Usage: "
              << argv[0]
              << " imagefile gridfile gridimagefile"
              << std::endl;
}


int
main(int argc, char** argv)
{
    try {
        if (argc < 4) {
            print_usage(argc, argv);
        } else {
            std::string image_fname(argv[1]);
            std::string grid_fname(argv[2]);
            std::string gridimage_fname(argv[3]);

            lti::loadImage loader;
            lti::image img;
            loader.load(image_fname, img);

            Grid grid(grid_fname.c_str());

            GridViewer gridviewer(lti::rgbPixel(255,255,0));
            gridviewer.apply(grid, img);

            lti::saveImage saver;
            saver.save(gridimage_fname, img);
        }
    } catch (lti::exception& exp) {
        std::cout << "An lti::exception was thrown: ";
        std::cout << exp.what() << std::endl;
    } catch (std::exception& exp) {
        std::cout << "std::exception was thrown: ";
        std::cout << exp.what() << std::endl;
    } catch (...) {
        std::cout << "Unknown exception thrown!" << std::endl;
    }

    return 0;
}
