#!/usr/bin/env python
#
# $Id$
#
# Copyright (C) 2003 Alan Grosskurth
#
# This file is part of Spatter.
#
# Spatter is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Spatter is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Spatter; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import pickle
import Image
import numarray
from microarray import *

def go(array_io):
    print 'Quantifying spots...'
    cy3 = Image.open(array_io.cy3_fname)
    cy5 = Image.open(array_io.cy5_fname)
    #bg = Image.open(root_fname + '-opened.pgm')
    a_cy3 = image2array(cy3)
    a_cy5 = image2array(cy5)
    spots = pickle.load(open(array_io.spot_fname))
    lines = []
    for s in spots:
        cy3_mean = (s.get_patch(a_cy3) * s.mask).mean()
        cy5_mean = (s.get_patch(a_cy5) * s.mask).mean()
        #bg_mean = bg.getpixel((s.centre[1], s.centre[0]))
        #str = '%d\t%d\t%d\t%d\t%d\n' % (cy3_mean, cy5_mean, bg_mean,
        #                                cy3_mean-bg_mean, cy5_mean-bg_mean)
        str = '%d\t%d\t%1.4f\n' % (cy3_mean, cy5_mean, cy5_mean/cy3_mean)
        lines.append(str)
    out = open(array_io.data_fname, 'w')
    out.writelines(lines)
    out.close()
    print 'Spot data saved as', array_io.data_fname

def main():
    pass

if __name__ == '__main__':
    main()
