// $Id$
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_SPOTLIST_HPP
#define INCLUDED_SPOTLIST_HPP

#include <vector>
#include <ltiPoint.h>
#include <ltiMatrix.h>

class Spot {
  public:
    Spot(const lti::point& origin, const lti::imatrix& mask);

    const lti::point& origin() const;
    const lti::imatrix& mask() const;
    const lti::point size() const;
    const lti::point center() const;

  private:
    lti::point m_origin;
    lti::imatrix m_mask;
};

class SpotList {
  public:
    SpotList();
    SpotList(const char* fname);

    void load(const char* fname);
    void save(const char* fname);

    std::vector< Spot > spots;
};

#endif // INCLUDED_SPOTLIST_HPP
