// $Id$
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_GRIDDER_HPP
#define INCLUDED_GRIDDER_HPP

#include "arraygeometry.hpp"
#include "grid.hpp"
#include <ltiImage.h>

class Gridder {
  public:
    Gridder();
    virtual Grid apply(const ArrayGeometry& geo,
                       const lti::image& img) = 0;
};


class MultiStepGridder : public Gridder {
  public:
    MultiStepGridder();
    virtual Grid apply(const ArrayGeometry& geo,
                       const lti::image& img);
};

#endif // INCLUDED_GRIDDER_HPP
