/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Weapon.h - Deklaration der Klasse CWeapon
//CWeapon wird für das Verwalten der Waffen der Raumschiffe benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef WEAPON_H
#define WEAPON_H

#include "Projectile.hpp"

#include <SFML/Audio.hpp>
#include <cstdio>
#include <log4cxx/logger.h>
//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Waffe
  * \author Steffen Nörtershäuser
  */
class CWeapon
{
public:
	/// Konstrukor und Destruktor
	CWeapon();
	~CWeapon();

	/// Diese Funktion intialisiert die Waffe
	void Init(const std::string& Name)
	{
		ReadData(Name);
	}

	/// Diese Funktion gibt den Namen der Waffe zurück
	const std::string& GetName() const { return m_Name; }

	/// Diese Funktion gibt die Geschwindigkeit der Projektile zurück
	float GetProjectileSpeedX() const { return m_ProjectileSpeedX; }

	/// Diese Funktion gibt die Geschwindigkeit der Projektile zurück
	float GetProjectileSpeedY() const { return m_ProjectileSpeedY; }

	/// Diese Funktion gibt die Schussgeschwindigkeit der Waffe zurück
	int GetShootSpeed() const { return m_ShootSpeed; }

	/// Diese Funktion gibt den Schaden der Waffe zurück
	int GetDamage() const { return m_Damage; }

	/// Diese Funktion gibt die WaffenGruppenID zurück
	int GetGroupID() const { return m_WeaponGroupID; }


	/// Diese Funktion rüstet die Waffe aus
	void Equip(bool Equip = true) { m_Equiped = Equip; }

	/// Diese Funktion gibt zurück ob die Waffe ausgerüstet ist
	bool IsEquiped() const { return m_Equiped; }

	/// Diese Funktion setzt die Waffe auf standard zurück
	void Reset() { m_Equiped = m_InitiallyEquiped; }


	/// Diese Funktion läßt die Waffe Schießen
	void Shoot(float X, float Y);

	/// Diese Funktion gibt die ProjektilAnzahl der Waffe zurück
	int GetProjectilCount() const { return m_Projectiles.size(); }

	/// Diese Funktion gibt die X-Koordinate des angebne Projektils zurück
	float GetProjectilX(int Projectil) const { return m_Projectiles[Projectil]->GetXPosition(); }

	/// Diese Funktion gibt die Y-Koordinate des angebne Projektils zurück
	float GetProjectilY(int Projectil) const { return m_Projectiles[Projectil]->GetYPosition(); }

	/// Diese Funktion gibt die Breite des KollisionSystem des angebne Projektils zurück
	float GetProjectilWidth(int Projectil) const { return m_Projectiles[Projectil]->GetCollisionSystemWidth(); }


	/// Diese Funktion zeichnet alle Schüße
	void DrawProjectiles();

	/// Diese Funktion überprüft ob die Projektile mit dem angeben KollisionSystem kollidieren
	/// Der dabei insgesamt angerichtie Schaden wird zurückgegebb
	int CheckCollision(const CCollisionSystem * CounterPart);


	/// Diese Funktion gibt alle Projektile der Waffe frei
	void ClearProjectils();


	/// Diese Funktion gibt die X-Projektile an der angeben Y-Koordinate, relativ zum Schiff
	int GetProjectilXRel(int YDistance) const;


	/// Diese Funktion gibt zurück ob die Waffe im Vordergrund ist oder nicht
	bool IsForeground() const { return m_Foreground; }
private:
	//Diese Funktion liest die WaffenDaten aus der angeben Datei
	void ReadData(const std::string& file);

	std::string m_Name;				//Der Name der Waffe
	float m_ProjectileSpeedX;	//Die Geschwindigkeit der Projektile
	float m_ProjectileSpeedY;	//Die Geschwindigkeit der Projektile
	float m_ProjectileAccelX;	//Die Beschleunigung der Projektile
	float m_ProjectileAccelY;	//Die Beschleunigung der Projektile

	float m_SpeedLimitX;		//Das Geschwindigkeits Limit auf der X-Achse
	float m_SpeedLimitY;		//Das Geschwindigkeits Limit auf der Y-Achse

	bool m_SpeedLimitXSmaller;	//Ob es das Speedlimit auf der X-Achse kleiner als benutzt
	bool m_SpeedLimitYSmaller;	//Ob es das Speedlimit auf der Y-Achse kleiner als benutzt

	std::string m_ProjectileImageName;	//Der DateiName des Projektil Bild
	int	  m_ShootSpeed;			//Die Wartezeit zwischen 2 Schüssen, in Millisekunden
	int	  m_LastShot;			//Wann das Letze mal geschossen wurde, in Millisekunden
	int	  m_Damage;				//Der Schaden der Schüsse
	int	  m_WeaponGroupID;		//Die WaffenGruppe, es können nicht 2 Waffen mit unterschiedlichen 
								//Namen aber gleichen WaffenGruppen ausgerüstet sein
	bool  m_ProjectileAutoRotate; //Ob die Rotation der Projektile angepasst werden soll

	bool  m_InitiallyEquiped;	//Ob die Waffe standard mäßig ausgerüstet ist
	bool  m_Equiped;			//Ob die Waffe ausgerüstet ist

	bool  m_Foreground;			//Ob die Waffe vor dem Schiff gezeichnet werden soll oder danach

	float m_X;					//Die X-Position des Waffe, relativ zur Schiffsposition
	float m_Y;					//Die Y-Position des Waffe, relativ zur Schiffsposition

	std::string m_ShootSoundFile;	//Der Datei Name des Schußsounds
	sf::Sound	m_ShootSound;		//Der Sound der beim Schießen abgespielt wird
	std::string m_HitSoundFile;		//Der Datei Name des Treffersounds
	sf::Sound	m_HitSound;			//Dieseer Sound wird bei einem Treffer abgespielt

	std::vector<CProjectile*> m_Projectiles;

	sProjectileData m_ProjectileData;

	log4cxx::LoggerPtr log_;
};

#endif
