/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Starfield.h - Deklaration der Klasse CStarfield
//CStarfield wird für das darstellen von Sternenfeldern benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef STARFIELD_H
#define STARFIELD_H

#include "Star.hpp"
#include <list>
#include <string>
#include <vector>

#define STARFIELD_PLANET_CHANCE		1
#define STARFIELD_PLANET_MAXCHANCE  4000
#define STARFIELD_PLANET_DELAY		1000

#define STARFIELD_ASTEROID_CHANCE	 1
#define STARFIELD_ASTEROID_MAXCHANCE 4000
#define STARFIELD_ASTEROID_MINSIZE	 6
#define STARFIELD_ASTEROID_MAXSIZE   9

#define STARFIELD_STAR_FRONT  110

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Sternenfeld
  * \author Steffen Nörtershäuser
  */
class CStarfield
{
public:
	/// Konstruktor und Destruktor
	CStarfield();
	~CStarfield();

	/// Diese Funktion intialisiert das Sternenfeld
	void Init(const std::string& FileName);

	/// Diese Funktion zeichnet das hintere und aktualisiert das gesamte Sternenfeld
	void DrawBack();

	/// Diese Funktion zeichnet das vordere Sternenfeld
	void DrawFront();

	/// Diese Funktion entfernt alle Planeten
	void RemovePlanets();

	/// Diese Funktion deaktiviert Planetenspawning
	void SetSpawnPlanets(bool Spawning) { m_SpawnPlanets = Spawning; }

	/// Diese Funktion gibt zurück Planeten gespawnt werden
	bool IsSpawningPlanets() const { return m_SpawnPlanets; }

	/// Diese Funktion legt die Breite des Sternenfeldes fest
	void SetWidth(int Width);
private:
	//Diese Funktion gibt alles wieder frei
	void CleanUp();

	//Diese Funktion liest die Sternendaten aus der angeben Datei aus
	void ReadData(std::string FileName, std::string* StarFile, int* StarCount);

	//Diese Funktion fügt den angeben Stern in die hintere Sternenstd::liste hinzu
	void InsertStarBack(CStar* Star);

	//Diese Funktion fügt den angeben Stern in die vordere Sternenstd::liste hinzu
	void InsertStarFront(CStar* Star);

	//Diese Funktion überprüft ob ein neuer Planet eingefügt werden soll
	void CheckForNewPlanet();

	//Diese Funktion überprüft ob ein neues Asteroidenfeld eingefügt werden soll
	void CheckForNewAsteroids();

	std::vector<AsteroidData*> m_AsteroidData; //Die Daten der Asteroiden
	std::list<CStar*> m_StarsFront;		//Die vorderen Sterne 
	std::list<CStar*> m_StarsBack;		//Die hinteren Sterne 
	std::vector<std::string> m_PlanetFiles;	//Die Planeten Datein

	bool m_SpawnPlanets;			//Ob Planeten erstellt werden sollen
	int  m_PlanetSpawnTime;			//Wann das letze mal ein Planet gespawnt wurde, in Millisekunden
	int  m_LastPlanet;				//Der letze Planet der gespawnt wurde

	int m_Width;					//Die Breite des Sternenfeldes
};

#endif

