/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Starfield.h - Deklaration der Klasse CStarfield
//CStarfield wird für das darstellen von Sternenfeldern benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef STAR_H
#define STAR_H

#include <string>
#include <SFML/Graphics.hpp>

#include "Globals.hpp"

#define ASTEROID_MIN_SPEED 0.5f
#define ASTEROID_MAX_SPEED 1.5f

#define STAR_ASTEROID_RADIUS    90
#define STAR_ANI_UPDATE 100

//////////////////////////////////////////////////////////////////////////////////////////////////

struct AsteroidData
{
	int FrameX;
	int FrameY;
	int FrameCount;
	std::string FileName;
};

/** \brief Stern
  * \author Steffen Nörtershäuser
  */
class CStar
{
public:
	/// Konstruktor und Destruktor
	CStar();
	~CStar();

	/// Diese Funktion intialisiert den Stern
	void Init(const std::string& FileName, int Layer, bool Planet = false, int FieldWidth = SCREEN_X_SIZE - HUD_SIZE_X);

	/// Diese Funktion intialisiert einen Asteroiden
	void InitAsteroid(AsteroidData* Data, int Layer, float XSpeed, float YSpeed, float X, float Y);


	/// Diese Funktion zeichnet und aktualisiert den Stern
	void Draw();

	/// Diese Funktion gibt den Layer des Sterns zurück
	int GetLayer() const { return m_Layer; }

	
	/// Diese Funktion gibt zurück ob der Stern ein Planet ist
	bool IsPlanet() const { return m_IsPlanet; }
	
	/// Diese Funktion gibt zurück ob der Stern entfernt werden kann
	bool CanBeRemoved() const { return m_CanBeRemoved; }


	/// Diese Funktion legt die Sternenfeld Breite fest
	void SetFieldWidth(int FieldWidth) { m_FieldWidth = FieldWidth; }

	
	/// Diese Funktion legt die Position fest
	void SetPosition(float X, float Y) { m_Star.SetPosition(X,Y); }
private:
	sf::Sprite m_Star;		//Das Sprite das Dargestellt wird
	float m_SpeedX;		//Wie schnell der Stern ist, auf der X-Achse
	float m_SpeedY;		//Wie schnell der Stern ist, auf der Y-Achse

	int m_Layer;		//Der Layer des Sterns

	bool m_IsPlanet;	 //Ob der Stern ein Planet ist
	bool m_IsAsteroid;   //Ob der Stern ein Asteroid ist
	bool m_CanBeRemoved; //Ob der Stern entfernt werden kann

	int m_LastAniUpdate; //Wann die Animation zuletzt erhöht wurde

	int m_FieldWidth;	 //Die Breite des Sternfelds

	unsigned frame_count;
	bool framed;
};

#endif

