/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SOUND_BUFFERS_HPP_INCLUDED
#define SOUND_BUFFERS_HPP_INCLUDED

#include <SFML/Audio.hpp>

#include <map>
#include <string>

/** \brief Sound Loader
  * \author Christoph Egger
  */
class SndBuffMgr
{
	public:
		sf::SoundBuffer& get_snd(const std::string& name)
		{
			if (sounds.find(name) != sounds.end())
				return sounds[name];
			else
			{
				sounds[name] = sf::SoundBuffer();
				sounds[name].LoadFromFile(std::string(DATADIR "/" PACKAGE_NAME "/") + name);
				return sounds[name];
			}
		}
	private:
		std::map<std::string,sf::SoundBuffer> sounds;
};

#endif

