/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Projectile.h - Deklaration der Klasse CProjectile
//CProjectile wird für das Verwalten der Schüße der Waffen benuzt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef PROJECTILE_H
#define PROJECTILE_H

#include <string>
#include <SFML/Graphics.hpp>

#include "CollisionSystem.hpp"
#include "Singletons.hpp"

//////////////////////////////////////////////////////////////////////////////////////////////////

struct sProjectileData
{
	std::string FileName;
	int FrameCount;
	int FrameWidth;
	int FrameHeight;
	long FrameDelay;
	std::string CollisionFile;
	float X;
	float Y;
	float SpeedX;
	float SpeedY;
	float AccelX;
	float AccelY;
	float SpeedLimitX;
	float SpeedLimitY;
	bool SpeedLimitXSmaller;
	bool SpeedLimitYSmaller;
	bool AutoRotate;
};

/** \brief Projektile
  * \author Steffen Nörtershäuser
  */
class CProjectile
{
public:
	//Konstrukor und Destruktor
	CProjectile();
	~CProjectile();

	//Diese Funktion intialisiert das Projektil
	void Init(sProjectileData ProjectileData);

	//Diese Funktion zeichnet das Projektil
	void Draw() 
	{
		sgl::get_window().Draw(m_Sprite);
		m_CollisionSystem.Draw();
	}

	//Diese Funktion aktualisiert das Projektil 
	void Update();

	//Diese Funktion gibt die X-Position des Projektils zurück
	float GetXPosition() const { return m_Sprite.GetPosition().y; }

	//Diese Funktion gibt die Y-Position des Projektils zurück
	float GetYPosition() const { return m_Sprite.GetPosition().y; }

	//Diese Funktion gibt das KollisionSystem zurück
	const CCollisionSystem * GetCollisionSystem() const { return &m_CollisionSystem; }

	//Diese Funktion gibt die Breite des KollisionSystems zurück
	float GetCollisionSystemWidth() const { return m_CollisionSystem.GetWidth(); }
private:
	sf::Sprite m_Sprite;	//Das Sprite des Schuß	
	CCollisionSystem m_CollisionSystem;	//Das KollisionSystem

	float m_SpeedX;		//Die Geschwindigkeit des Schuß
	float m_SpeedY;		//Die Geschwindigkeit des Schuß

	float m_SpeedLimitX; //Das Geschwindigkeits Limit des Schuß auf der X-Achse
	bool  m_SpeedLimitXSmaller;	//Ob es das Speedlimit auf der X-Achse kleiner als benutzt

	float m_SpeedLimitY; //Das Geschwindigkeits Limit des Schuß auf der Y-Achse
	bool  m_SpeedLimitYSmaller;	//Ob es das Speedlimit auf der Y-Achse kleiner als benutzt

	float m_AccelX;		//Die Beschleunigung des Schußes
	float m_AccelY;		//Die Beschleunigung des Schußes

	bool m_AutoRotate;	//Ob die Rotation des Sprites angepasst werden soll

	long m_LastAniFrameInc;	//Wann das letzte mal der Animationsframe inkrementiert wurde
	long m_AniFrameDelay;	//Wie lange zwischen dem inkrementieren des Animationsframes gewartet wird
};

#endif
