/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Projectile.hpp"
#include "Singletons.hpp"

#include <cmath>

CProjectile::CProjectile()
		: m_SpeedX(0.0f),
		  m_SpeedY(0.0f),
		  m_SpeedLimitX(-99999.0f),
		  m_SpeedLimitXSmaller(false),
		  m_SpeedLimitY(-99999.0f),
		  m_SpeedLimitYSmaller(false),
		  m_AccelX(0.0f),
		  m_AccelY(0.0f),
		  m_AutoRotate(false),
		  m_LastAniFrameInc(sgl::get_clock().GetElapsedTime()*1000),
		  m_AniFrameDelay(999999)
{}

CProjectile::~CProjectile()
{
}

void CProjectile::Init(sProjectileData ProjectileData)
{
	m_SpeedX = ProjectileData.SpeedX;
	m_SpeedY = ProjectileData.SpeedY;

	m_AccelX = ProjectileData.AccelX;
	m_AccelY = ProjectileData.AccelY;

	m_AutoRotate = ProjectileData.AutoRotate;

	m_SpeedLimitX = ProjectileData.SpeedLimitX;
	m_SpeedLimitXSmaller = ProjectileData.SpeedLimitXSmaller;

	m_SpeedLimitY = ProjectileData.SpeedLimitY;
	m_SpeedLimitYSmaller = ProjectileData.SpeedLimitYSmaller;

	m_LastAniFrameInc = sgl::get_clock().GetElapsedTime()*1000;
	m_AniFrameDelay	  = ProjectileData.FrameDelay;

	m_Sprite.SetImage(sgl::get_imagemgr().get_img(ProjectileData.FileName));
	
	m_Sprite.SetPosition(ProjectileData.X,ProjectileData.Y);

	if(m_AutoRotate == true)
	{
		int Degree = (std::atan2(m_SpeedY, m_SpeedX) + M_PI / 2)*180.0f/M_PI;
		m_Sprite.SetRotation(Degree);
	}

	m_CollisionSystem.Init(ProjectileData.CollisionFile);
	m_CollisionSystem.SetPosition(ProjectileData.X + m_Sprite.GetSize().x/2,ProjectileData.Y + m_Sprite.GetSize().y/2);
}

void CProjectile::Update()
{
	m_Sprite.Move(m_SpeedX,m_SpeedY); 

	m_SpeedX += m_AccelX;
	m_SpeedY += m_AccelY;

	if(m_SpeedLimitXSmaller == true)
	{
		if(m_SpeedX > m_SpeedLimitX)
		{
			m_SpeedX = m_SpeedLimitX;
		}
	}
	else
	{
		if(m_SpeedX < m_SpeedLimitX)
		{
			m_SpeedX = m_SpeedLimitX;
		}
	}

	if(m_SpeedLimitYSmaller == true)
	{
		if(m_SpeedY > m_SpeedLimitY)
		{
			m_SpeedY = m_SpeedLimitY;
		}
	}
	else
	{
		if(m_SpeedY < m_SpeedLimitY)
		{
			m_SpeedY = m_SpeedLimitY;
		}
	}

	if(m_AutoRotate == true)
	{
		int Degree = (std::atan2(m_SpeedY,
					   m_SpeedX) + M_PI / 2)*180.0f/M_PI;
		m_Sprite.SetRotation(Degree);
	}

	if(sgl::get_clock().GetElapsedTime()*1000 - m_LastAniFrameInc > m_AniFrameDelay)
	{
		m_LastAniFrameInc = sgl::get_clock().GetElapsedTime()*1000;
		/// \todo Finde eine Schlaue Idee wegen IncFrame()
		// m_Sprite.IncFrame();
	}

	m_CollisionSystem.SetPosition(m_Sprite.GetPosition().x,m_Sprite.GetPosition().y);
}

