/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//PowerUp.h - Deklaration der Klasse CPowerUp
//CPowerUp Klasse wird für das Verwalten von PowerUps benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef POWERUP_H
#define POWERUP_H

#include "CollisionSystem.hpp"
#include "Singletons.hpp"

#include <string>

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Power Ups
  * \author Steffen Nörtershäuser
  */
class CPowerUp
{
public:
	/// Konstruktor und Destruktor
	CPowerUp();
	~CPowerUp();

	/// Diese Funktion initalisiert das PowerUp
	void Init(const std::string& FileName);

	/// Diese Funktion legt die Position des PowerUps fest
	void SetPosition(float X, float Y) { m_Sprite.SetPosition(X,Y); }

	/// Diese Funktion gibt die Waffe die ausgerüstete werden soll zurück
	std::string GetEquipWeapon() const { return m_EquipWeapon; }

	/// Diese Funktion gibt die WaffenGruppenID zurück
	int GetWeaponGroupID() const { return m_WeaponGroupInc; }

	/// Diese Funktion gibt zurück wie stark der Bonus das Schiff repariert
	int GetRepair() const { return m_Repair; }

	/// Diese Funktion zeichnet das PowerUp
	void Draw() 
	{ 
		sgl::get_window().Draw(m_Sprite); 
		m_CollisionSystem.SetPosition(m_Sprite.GetPosition().y,m_Sprite.GetPosition().y);
		m_CollisionSystem.Draw();
	}

	/// Diese Funktion aktualisiert das PowerUp
	void Update();

	/// Diese Funktion gibt das KollisionSystem zurück
	const CCollisionSystem* GetCollisionSystem() const { return &m_CollisionSystem; }
private:
	sf::Sprite m_Sprite;	//Das Sprite zum anzeigen des PowerUps
	CCollisionSystem m_CollisionSystem;	//Das KollisionSystem

	int m_LastFrameUpdate;	//Die Millisekunden als die Frames des Sprites das letze mal Inkrementiert wurden
	int m_FrameDelay;		//Wie lange zwischen dem aktualisiern der Frames gewartete wird

	float m_Speed;			//Die Geschwindigkeit des PowerUps

	std::string m_EquipWeapon;	//Die Waffe die beim Aufsammeln ausgerüstet wird
	int	   m_WeaponGroupInc;//Die WaffenGruppe mti der angeben ID wird inkrementiert
	int	   m_Repair;		//Wie stark der Bonus das Schiff repariert
};

#endif
