/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "PowerUp.hpp"

#include <cstdio>

CPowerUp::CPowerUp()
		: m_LastFrameUpdate(0),
		  m_FrameDelay(0),
		  m_WeaponGroupInc(-1)
{}

CPowerUp::~CPowerUp()
{}

void CPowerUp::Init(const std::string& FileName)
{
	char strBuf[100];
	std::string HelpString;
	std::string OldString;
	std::string DataString;
	std::string ImageName;
	
	int FrameCount = 1;
	float FrameWidth = -1;
	float FrameHeight = -1;

	FILE* ShipFile = std::fopen( ( std::string(DATADIR "/" PACKAGE_NAME "/") + FileName ).c_str(),"r");
	if(ShipFile == NULL)
	{
		return;
	}

	while(std::feof(ShipFile) == 0)
	{
		std::fscanf(ShipFile,"%s",strBuf);
		HelpString = strBuf;

		if(HelpString == "=")
		{
			if(OldString == "Image")
			{
				std::fscanf(ShipFile,"%s",strBuf);
				ImageName = strBuf;
			}
			
			if(OldString == "FrameCount")
			{
				std::fscanf(ShipFile,"%d",&FrameCount);
			}
		
			if(OldString == "FrameWidth")
			{
				std::fscanf(ShipFile,"%f",&FrameWidth);
			}

			if(OldString == "FrameHeight")
			{
				std::fscanf(ShipFile,"%f",&FrameHeight);
			}

			if(OldString == "FrameDelay")
			{
				std::fscanf(ShipFile,"%d",&m_FrameDelay);
			}

			if(OldString == "Speed")
			{
				std::fscanf(ShipFile,"%f",&m_Speed);
			}

			if(OldString == "EquipWeapon")
			{
				std::fscanf(ShipFile,"%s",strBuf);
				m_EquipWeapon = strBuf;
			}

			if(OldString == "IncWeaponGroup")
			{
				std::fscanf(ShipFile,"%d",&m_WeaponGroupInc);
			}

			if(OldString == "Repair")
			{
				std::fscanf(ShipFile,"%d",&m_Repair);
			}
			
			if(OldString == "CollisionSystem")
			{
				std::fscanf(ShipFile,"%s",strBuf);
				DataString = strBuf;
				m_CollisionSystem.Init(DataString);
			}

		}

		OldString = HelpString;
	}

	std::fclose(ShipFile);
}

void CPowerUp::Update()
{
	if(sgl::get_clock().GetElapsedTime()*1000 - m_LastFrameUpdate > m_FrameDelay)
	{
		/// \todo m_Sprite.IncFrame();
		m_LastFrameUpdate = sgl::get_clock().GetElapsedTime()*1000;
	}

	m_Sprite.Move(0.0f,m_Speed);
}

