/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Player.cpp - Definition der Klasse CPlayer
//CPlayer Klasse die für das Verwalten der Spieler benutzt wird
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


#include "Player.hpp"
#include <boost/format.hpp>
#include <SFML/Window.hpp>
#include <libintl.h>
#define _(string) gettext(string)

#include "MathFuncs.hpp"
#include <cmath>
#include "Singletons.hpp"


CPlayer::CPlayer()
		: m_Ship(NULL),
		  m_Lives(PLAYER_INITIAL_LIVES),
		  m_LiveString((boost::format(_("Lives: %1%")) % m_Lives).str()),
		  m_Respawning(false),
		  m_LastDeadTime(0)
{}

CPlayer::~CPlayer()
{
	delete m_Ship;
}

void CPlayer::Init(const std::string& FileName)
{
	if(m_Ship != NULL)
	{
		delete m_Ship;
		m_Ship = NULL;
	}

	m_Ship = new CShip;
	m_Ship->Init(FileName);
	m_Ship->SetPosition((SCREEN_X_SIZE - HUD_SIZE_X)/2,SCREEN_Y_SIZE - 100);
}

void CPlayer::Update()
{
	static float last_frame(sgl::get_clock().GetElapsedTime());
	
	float movement = 
			(sgl::get_clock().GetElapsedTime() - static_cast<float>(last_frame))
			* 100;
	
	last_frame = sgl::get_clock().GetElapsedTime();
	
	if(m_Ship == NULL || IsDead())
	{
		return;
	}

	if(m_Respawning == true)
	{
		m_Ship->SetAlpha(std::fabs(std::sin((sgl::get_clock().GetElapsedTime()*1000 - m_LastDeadTime) * 0.005f)));

		if(sgl::get_clock().GetElapsedTime()*1000 - m_LastDeadTime > PLAYER_RESPAWN_TIME)
		{
			m_Respawning = false;
			m_Ship->SetAlpha(1.0f);

			m_Ship->SetInvulnerable(false);
		}
	}


	if(sgl::get_window().GetInput().IsKeyDown(sf::Key::Left))
	{
		if(m_Ship->GetXPosition() > 0)
		{
			m_Ship->MoveX(-1 * movement);
		}
	}
	else if(sgl::get_window().GetInput().IsKeyDown(sf::Key::Right))
	{
		if(m_Ship->GetXPosition() < (SCREEN_X_SIZE - HUD_SIZE_X))
		{
			m_Ship->MoveX(1 * movement);
		}
	}

	if(sgl::get_window().GetInput().IsKeyDown(sf::Key::Up))
	{
		if(m_Ship->GetYPosition() > 0)
		{
			m_Ship->MoveY(-1 * movement);
		}
	}
	else if(sgl::get_window().GetInput().IsKeyDown(sf::Key::Down))
	{
		if(m_Ship->GetYPosition() < SCREEN_Y_SIZE)
		{
			m_Ship->MoveY(1 * movement);
		}
	}

	if(sgl::get_window().GetInput().IsKeyDown(sf::Key::Space))
	{
		m_Ship->Shoot();
	}
}

bool CPlayer::CanBeRemoved() 
{ 
	//Diese Funktion gibt zurück ob der Spieler entfernt werden kann ist

	if(m_Ship == NULL)
	{
		return false;
	}

	if(m_Ship->CanBeRemoved() && m_Ship->IsDead())
	{
		if(m_Lives > 0)
		{
			--m_Lives;

			m_LiveString = (boost::format(_("Lives: %1%")) % m_Lives).str();

			m_Ship->SetPosition((SCREEN_X_SIZE - HUD_SIZE_X)/2,SCREEN_Y_SIZE - 100);
			m_Ship->SetCurArmor(m_Ship->GetMaxArmor());
			m_Respawning = true;

			m_Ship->SetInvulnerable(true);

			m_LastDeadTime = sgl::get_clock().GetElapsedTime()*1000;

			return false;
		}
		else
		{
			return true;
		}
	}
	return false;
}

