/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Particle.hpp"
#include "Singletons.hpp"
#include "MathFuncs.hpp"

CParticle::CParticle()
		: m_LastAniUpdate(sgl::get_clock().GetElapsedTime()*1000),
		  m_AniSpeed(1000),
		  m_SpawnTime(0),
		  m_LifeTime(1000),
		  m_StartAlpha(0),
		  m_EndAlpha(255),
		  m_StartVelX(0.0f),
		  m_EndVelX(0.0f),
		  m_StartVelY(0.0f),
		  m_EndVelY(0.0f)
{}

CParticle::~CParticle()
{}

void CParticle::Init(const std::string& TexName, float FrameWidth, float FrameHeight, int FrameCount)
{
	/// \todo m_Sprite.Init(lpDevice,TexManager,TexName,FrameWidth,FrameHeight,FrameCount);

	m_SpawnTime = sgl::get_clock().GetElapsedTime()*1000;
	m_LastAniUpdate = sgl::get_clock().GetElapsedTime()*1000;
}

bool CParticle::Remove()
{
	return (sgl::get_clock().GetElapsedTime()*1000 - m_SpawnTime > m_LifeTime);
}

void CParticle::Update()
{
	float Time = ((sgl::get_clock().GetElapsedTime()*1000 - m_SpawnTime)) / m_LifeTime;

	float ScaleX = lerp(m_StartScaleX,m_EndScaleX,Time);
	float ScaleY = lerp(m_StartScaleY,m_EndScaleY,Time);

	m_Sprite.SetScale(ScaleX,ScaleY);


	int Red = lerp(m_StartRed,m_EndRed,Time);
	int Green = lerp(m_StartGreen,m_EndGreen,Time);
	int Blue = lerp(m_StartBlue,m_EndBlue,Time);
	int Alpha = lerp(m_StartAlpha,m_EndAlpha,Time);

	m_Sprite.SetColor(sf::Color(Red,Green,Blue,Alpha));


	float VelX = lerp(m_StartVelX,m_EndVelX,Time);
	float VelY = lerp(m_StartVelY,m_EndVelY,Time);
	
	m_Sprite.Move(VelX,VelY);

	if(sgl::get_clock().GetElapsedTime()*1000 - m_LastAniUpdate > m_AniSpeed)
	{
		m_LastAniUpdate = sgl::get_clock().GetElapsedTime()*1000;
		/// \todo m_Sprite.IncFrame();
	}
}

void CParticle::Draw()
{
	sgl::get_window().Draw(m_Sprite);
}
