/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Menu.h - Deklaration der Klasse CMenu
//CMenu wird für das Verwalten und Darstellen des Menüs benutzt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef MENU_H
#define MENU_H

#include <string>
#include <SFML/Graphics.hpp>
#include <log4cxx/logger.h>

#include "Globals.hpp"
#include "Bitmapfont.hpp"
#include "MenuListField.hpp"
#include "SaveManager.hpp"

#define MENU_BUTTON_HIT_DELAY 500

#define MENU_CLOSE_NONE    0
#define MENU_CLOSE_START   1
#define MENU_CLOSE_LOAD	   2
#define MENU_CLOSE_CREDITS 3

#define MENU_SUB_START 0
#define MENU_SUB_LOAD  1

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Menü
  * \author Steffen Nörtershäuser
  */
class CMenu
{
public:
	/// Konstruktor und Destruktor
	CMenu();
	~CMenu();

	/// Diese Funktion intialisiert das Menü
	void Init(CBitmapFont* BitMapFont, int* MouseX, int* MouseY, 
			  bool* MouseDown);

	/// Diese Funktion öffnet das Menü
	std::string Update();

	/// Diese Funktion gibt zurück ob das Menü geschlossen werden soll
	int Close() 
	{ 
		int Close = m_Close;
		m_Close = MENU_CLOSE_NONE;
		return Close; 
	}

	/// Diese Funktion legt das Untermenü fest
	void SetSubMenu(int Menu)
	{ 
		m_CurSubMenu = Menu; 
		m_ListField.SetScroll(0);
		m_SaveListField.SetScroll(0);
	}
private:
	//Diese Funktion zeichnet alles
	void RenderAll();

	//Diese Funktion zeichnet den Start screen
	void RenderStart();

	//Diese Funktion zeichnet den Load screen
	void RenderLoad();


	//Diese Funktion überprüft ob ein Button gedrückt wurde usw.
	int  UpdateAll();

	//Diese Funktion liest die Kampagnen aus
	void ReadCampaignData();


	//Diese Funktion wechselt das Untermenü zu Laden
	void ChangeSubMenuToLoad();


	//Diese Funktion gibt den momentan ausgewählten Speicherstand zurück
	std::string GetCurSaveName();

	CMenuListField m_ListField;		//Das Listenfeld für die Kampagnen
	CMenuListField m_SaveListField; //Das Listenfeld für die saves

	sf::Sprite m_BackSprite;	//Das Hintergrund Bild
	sf::Sprite m_CreditsSprite;//Das Credits Bild
	sf::Sprite	m_TopSprite;	//Das Obere Bild

	sf::Sprite m_StartSpriteUp;  //Das Start Bild
	sf::Sprite m_StartSpriteDown;  //Das gedrückte Start Bild

	sf::Sprite m_LoadSpriteUp;		//Das Laden Bild
	sf::Sprite m_LoadSpriteDown;	//Das gedrückte Laden Bild

	sf::Sprite m_ExitSpriteUp;		//Das Beenden Bild
	sf::Sprite m_ExitSpriteDown;   //Das gedrückte Beenden Bild

	sf::Sprite m_CreditsSpriteUp;  //Das Credits Bild
	sf::Sprite m_CreditsSpriteDown;  //Das gedrückte Credits Bild

	sf::Sprite m_BackSpriteUp;		//Das Zurück Bild
	sf::Sprite m_BackSpriteDown;   //Das gedrückte Zurück Bild


	sf::Sprite m_ScrollUpSpriteDis; //Das deaktivierte Nach Oben Scroll Bild
	sf::Sprite m_ScrollUpSpriteUp; //Das Nach Oben Scroll Bild
	sf::Sprite m_ScrollUpSpriteDown; //Das gedrückte Nach Oben Scroll Bild

	sf::Sprite m_ScrollDownSpriteDis; //Das deaktivierte Nach Unten Scroll Bild
	sf::Sprite m_ScrollDownSpriteUp; //Das Nach Oben Unten Bild
	sf::Sprite m_ScrollDownSpriteDown; //Das gedrückte Nach Unten Scroll Bild

	int* m_MouseX;			//Die X-Koordinate der Maus
	int* m_MouseY;			//Die Y-Koordinate der Maus
	bool* m_MouseDown;		//Ob die Maus gedrückt wurde
	bool m_HasHitMouse;		//Ob die Maus gerade gedrückt wurde
	int m_HasHitMouseTime;  //Wann die Maus gedrückt wurde, in Millisekunden

	bool m_PushingStart;	//Ob der Startknopf gerade gedrückt wird
	bool m_PushingLoad;		//Ob der Ladenknopf gerade gedrückt wird
	bool m_PushingCredits;	//Ob der Creditsknopf gerade gedrückt wird
	bool m_PushingExit;		//Ob der Beendenknopf gerade gedrückt wird

	bool m_ScrollingUp;		//Ob gerade hochgescrollt wird
	bool m_ScrollingDown;	//Ob gerade runtergescrollt wird

	int  m_Close;			//Ob das Menü geschlossen werden soll

	int  m_CurSubMenu;		//Welches UnterMenü gerade ausgewählt ist
	
	log4cxx::LoggerPtr log_;
};
#endif
