/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Menu.hpp"
#include "Singletons.hpp"
#include <boost/filesystem.hpp>

#include <cstring>
#include <cstdlib>

#include <libintl.h>
#define _(string) gettext(string)

CMenu::CMenu()
		: log_(log4cxx::Logger::getLogger("Menu"))
{
	/// \todo Initialisierungsliste
	m_MouseX    = NULL;	
	m_MouseY    = NULL;	
	m_MouseDown = NULL;

	m_PushingStart = false;
	m_PushingLoad = false;
	m_PushingCredits = false;
	m_PushingExit = false;

	m_Close = MENU_CLOSE_NONE;

	m_CurSubMenu = MENU_SUB_START;
}

CMenu::~CMenu()
{}

void CMenu::Init(CBitmapFont* BitMapFont, int* MouseX, int* MouseY, bool* MouseDown)
{
	if(MouseX == NULL || MouseY == NULL || MouseDown == NULL)
	{
		return;
	}

	m_MouseX = MouseX;
	m_MouseY = MouseY;

	m_MouseDown = MouseDown;

	FILE* MenuFile = fopen(DATADIR "/" PACKAGE_NAME "/" "/Menu.txt","r");
	
	if (!MenuFile)
	{
		LOG4CXX_ERROR( log_, _("Could not open Menu file"));
		std::exit(-1);
	}

	char strBuf[100];
	std::string HelpString;
	std::string OldString;
	std::string DataString;
	
	std::string ListSelImage = "";

	//Alle Daten auslesen
	while(std::feof(MenuFile) == 0)
	{
		std::fscanf(MenuFile,"%s",strBuf);
		HelpString = strBuf;

		if(HelpString == "=")
		{
			if(OldString.compare("Background") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_BackSprite.SetImage(sgl::get_imagemgr().get_img(DataString));
			}
			else if(OldString.compare("TopImage") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_TopSprite.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_TopSprite.SetPosition(SCREEN_X_SIZE / 2-300, 65);
			}

			else if(OldString.compare("StartImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_StartSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_StartSpriteUp.SetPosition(30, 510);
			}
			else if(OldString.compare("StartImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_StartSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_StartSpriteDown.SetPosition(30, 510);
			}

			else if(OldString.compare("LoadImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_LoadSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_LoadSpriteUp.SetPosition(30, 570);
			}
			else if(OldString.compare("LoadImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_LoadSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_LoadSpriteDown.SetPosition(30, 570);
			}

			else if(OldString.compare("ExitImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ExitSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ExitSpriteUp.SetPosition(30, 690);
			}
			else if(OldString.compare("ExitImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ExitSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ExitSpriteDown.SetPosition(30, 690);
			}

			else if(OldString.compare("CreditsImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_CreditsSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_CreditsSpriteUp.SetPosition(30, 630);
			}
			else if(OldString.compare("CreditsImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_CreditsSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_CreditsSpriteDown.SetPosition(30, 630);
			}

			else if(OldString.compare("BackImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_BackSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_BackSpriteUp.SetPosition(30, 690);
			}
			else if(OldString.compare("BackImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_BackSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_BackSpriteDown.SetPosition(30, 690);
			}


			else if(OldString.compare("ListSelImage") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				ListSelImage = strBuf;
			}

			else if(OldString.compare("ListScrollUpImageDis") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ScrollUpSpriteDis.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ScrollUpSpriteDis.SetPosition(960, 240);
			}
			else if(OldString.compare("ListScrollUpImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ScrollUpSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ScrollUpSpriteUp.SetPosition(960, 240);
			}
			else if(OldString.compare("ListScrollUpImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ScrollUpSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ScrollUpSpriteDown.SetPosition(960, 240);
			}

			else if(OldString.compare("ListScrollDownImageDis") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ScrollDownSpriteDis.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ScrollDownSpriteDis.SetPosition(960, 700);
			}
			else if(OldString.compare("ListScrollDownImageUp") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ScrollDownSpriteUp.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ScrollDownSpriteUp.SetPosition(960, 700);
			}
			else if(OldString.compare("ListScrollDownImageDown") == 0)
			{
				std::fscanf(MenuFile,"%s",strBuf);
				DataString = strBuf;
				m_ScrollDownSpriteDown.SetImage(sgl::get_imagemgr().get_img(DataString));
				m_ScrollDownSpriteDown.SetPosition(960, 700);
			}

		}

		OldString = HelpString;
	}

	std::fclose(MenuFile);

	m_ListField.Init(BitMapFont, ListSelImage);
	m_ListField.SetSize(655,470);
	m_ListField.SetPosition(270,250);

	m_SaveListField.Init(BitMapFont, ListSelImage);
	m_SaveListField.SetSize(655,470);
	m_SaveListField.SetPosition(270,250);

	m_CreditsSprite.SetImage(sgl::get_imagemgr().get_img("gfx/Briefing/credits.png"));
	m_CreditsSprite.SetPosition(36,240);

	ReadCampaignData();
}

std::string CMenu::Update()
{
	//Diese Funktion öffnet das Menü

	if(m_MouseX == NULL || m_MouseY == NULL || m_MouseDown == NULL)
	{
		return "";
	}

	m_Close = UpdateAll();

	if(m_Close == MENU_CLOSE_NONE)
	{
		RenderAll();
	}

	std::string OutName;
	
	if(m_CurSubMenu == MENU_SUB_START)
	{
		OutName = DATADIR "/" PACKAGE_NAME "/" "/kampagnen/";
		OutName += m_ListField.GetCurEntry();
		OutName += ".ssk";
	}
	else if(m_CurSubMenu == MENU_SUB_LOAD)
	{
		OutName = GetCurSaveName();
	}

	return OutName;
}

void CMenu::RenderAll()
{
	sgl::get_window().Draw(m_BackSprite);
	sgl::get_window().Draw(m_TopSprite);

	bool CanScrollUp = false;
	bool CanScrollDown = false;

	if(m_CurSubMenu == MENU_SUB_START)
	{
		CanScrollUp = m_ListField.CanScrollUp();
		CanScrollDown = m_ListField.CanScrollDown();
		RenderStart();
	}
	else if(m_CurSubMenu == MENU_SUB_LOAD)
	{
		CanScrollUp = m_SaveListField.CanScrollUp();
		CanScrollDown = m_SaveListField.CanScrollDown();
		RenderLoad();
	}

	if(CanScrollUp == true)
	{
		if(m_ScrollingUp == false)
		{
			sgl::get_window().Draw(m_ScrollUpSpriteUp);
		}
		else
		{
			sgl::get_window().Draw(m_ScrollUpSpriteDown);
		}
	}
	else
	{
		sgl::get_window().Draw(m_ScrollUpSpriteDis);
	}

	if(CanScrollDown == true)
	{
		if(m_ScrollingDown == false)
		{
			sgl::get_window().Draw(m_ScrollDownSpriteUp);
		}
		else
		{
			sgl::get_window().Draw(m_ScrollDownSpriteDown);
		}
	}
	else
	{
		sgl::get_window().Draw(m_ScrollDownSpriteDis);
	}

	sgl::get_window().Draw(m_CreditsSprite);
}

void CMenu::RenderStart()
{
	m_ListField.Draw();

	if(m_PushingStart == false)
	{
		sgl::get_window().Draw(m_StartSpriteUp);
	}
	else
	{
		sgl::get_window().Draw(m_StartSpriteDown);
	}

	if(m_PushingLoad == false)
	{
		sgl::get_window().Draw(m_LoadSpriteUp);
	}
	else
	{
		sgl::get_window().Draw(m_LoadSpriteDown);
	}

	if(m_PushingCredits == false)
	{
		sgl::get_window().Draw(m_CreditsSpriteUp);
	}
	else
	{
		sgl::get_window().Draw(m_CreditsSpriteDown);
	}

	if(m_PushingExit == false)
	{
		sgl::get_window().Draw(m_ExitSpriteUp);
	}
	else
	{
		sgl::get_window().Draw(m_ExitSpriteDown);
	}
}

void CMenu::RenderLoad()
{
	if(m_SaveListField.GetEntryCount() != 0)
	{
		m_SaveListField.Draw();
	}

	if(m_PushingLoad == false)
	{
		sgl::get_window().Draw(m_LoadSpriteUp);
	}
	else
	{
		sgl::get_window().Draw(m_LoadSpriteDown);
	}

	//Hier Exit da selbe Maße und Position
	if(m_PushingExit == false)
	{
		sgl::get_window().Draw(m_BackSpriteUp);
	}
	else
	{
		sgl::get_window().Draw(m_BackSpriteDown);
	}
}

int CMenu::UpdateAll()
{
	if((*m_MouseDown) == false)
	{
		m_ScrollingUp = false;
		m_ScrollingDown = false;
		m_HasHitMouse = false;
		
		if(m_PushingStart == true && m_CurSubMenu == MENU_SUB_START)
		{
			m_PushingStart = false;
			return MENU_CLOSE_START;
		}

		if(m_PushingLoad == true && m_CurSubMenu == MENU_SUB_START)
		{
			m_PushingLoad = false;
			ChangeSubMenuToLoad();
		}
		else if(m_PushingLoad == true)
		{
			m_PushingLoad = false;
			m_LoadSpriteUp.SetPosition(m_LoadSpriteUp.GetPosition().x, 570);	
			m_LoadSpriteDown.SetPosition(m_LoadSpriteUp.GetPosition().x, m_LoadSpriteUp.GetPosition().y);	
			return MENU_CLOSE_LOAD;
		}

		if(m_PushingCredits == true && m_CurSubMenu == MENU_SUB_START)
		{
			m_PushingCredits = false;
			return MENU_CLOSE_CREDITS;
		}

		if(m_PushingExit == true && m_CurSubMenu == MENU_SUB_START)
		{
			m_PushingExit = false;
			std::exit(0);
			return MENU_CLOSE_START;
		}
		else if(m_PushingExit == true && m_CurSubMenu == MENU_SUB_LOAD)
		{
			m_PushingExit = false;
			m_LoadSpriteUp.SetPosition(m_LoadSpriteUp.GetPosition().x, 570);	
			m_LoadSpriteDown.SetPosition(m_LoadSpriteUp.GetPosition().x, m_LoadSpriteUp.GetPosition().y);	
			m_CurSubMenu = MENU_SUB_START;
		}

		m_PushingStart = false;
		m_PushingExit = false;
		return MENU_CLOSE_NONE;
	}

	if(sgl::get_clock().GetElapsedTime()*1000 - m_HasHitMouseTime > MENU_BUTTON_HIT_DELAY)
	{
		m_HasHitMouse = false;
		m_HasHitMouseTime = sgl::get_clock().GetElapsedTime()*1000;
	}

	int MouseX = (*m_MouseX);
	int MouseY = (*m_MouseY);

	if(MouseX > 33 && MouseX < 33 + m_StartSpriteUp.GetSubRect().GetWidth() &&
	   MouseY > 508 && MouseY < 508 + m_StartSpriteUp.GetSubRect().GetHeight())
	{
		m_PushingStart = true;
	}
	else
	{
		m_PushingStart = false;
	}


	int LoadY = 568;
	if(m_CurSubMenu == MENU_SUB_LOAD)
	{
		LoadY = 628;
	}

	if(MouseX > 33 && MouseX < 33 + m_LoadSpriteUp.GetSubRect().GetWidth() &&
	   MouseY > LoadY && MouseY < LoadY + m_LoadSpriteUp.GetSubRect().GetHeight())
	{
		m_PushingLoad = true;
	}
	else
	{
		m_PushingLoad = false;
	}


	if(MouseX > 31 && MouseX < 31 + m_CreditsSpriteUp.GetSubRect().GetWidth() &&
	   MouseY > 628 && MouseY < 628 + m_CreditsSpriteUp.GetSubRect().GetHeight() && m_CurSubMenu == MENU_SUB_START)
	{
		m_PushingCredits = true;
	}
	else
	{
		m_PushingCredits = false;
	}


	if(MouseX > 31 && MouseX < 31 + m_ExitSpriteUp.GetSubRect().GetWidth() &&
	   MouseY > 686 && MouseY < 686 + m_ExitSpriteUp.GetSubRect().GetHeight())
	{
		m_PushingExit = true;
	}
	else
	{
		m_PushingExit = false;
	}


	if(m_HasHitMouse == true)
	{
		return false;
	}

	m_HasHitMouse = true;
	m_HasHitMouseTime = sgl::get_clock().GetElapsedTime()*1000;

	int ScrollX = 950;

	int ID = 0;

	if(MouseX > m_ListField.GetXPosition() && MouseX < m_ListField.GetXPosition() + m_ListField.GetXSize() &&
	   MouseY > m_ListField.GetYPosition() && MouseY < m_ListField.GetYPosition() + m_ListField.GetYSize() - 50)
	{
		ID = (MouseY - m_ListField.GetYPosition()) / 32;
		m_ListField.SelectEntryWithScroll(ID);
		m_SaveListField.SelectEntryWithScroll(ID);
	}

	if(MouseX >= ScrollX && MouseX <= ScrollX + m_ScrollUpSpriteUp.GetSubRect().GetWidth() &&
	   MouseY >= 255 && MouseY <= 255 + m_ScrollUpSpriteUp.GetSubRect().GetHeight())
	{
		m_ScrollingUp = true;
		m_ListField.Scroll(-1);
		m_SaveListField.Scroll(-1);
	}
	else
	{
		m_ScrollingUp = false;
	}

	if(MouseX > ScrollX && MouseX < ScrollX + m_ScrollDownSpriteUp.GetSubRect().GetWidth() &&
	   MouseY > 691 && MouseY < 691 + m_ScrollDownSpriteUp.GetSubRect().GetHeight())
	{
		m_ScrollingDown = true;
		m_ListField.Scroll(1);
		m_SaveListField.Scroll(1);
	}
	else
	{
		m_ScrollingDown = false;
	}

	return false;
}


void CMenu::ReadCampaignData()
{
	long pos = 0;
	const long MaxLength = 200;
	std::string CampaignName;

	m_ListField.Clear();

	char Direction[MaxLength*3];
	char DataFile[MaxLength*3];
	std::memset(Direction,'\0',MaxLength*3);
	std::memset(DataFile,'\0',MaxLength*3);
	std::strcpy(Direction,DATADIR "/" PACKAGE_NAME "/" "/kampagnen/*.ssk");
	std::string Folder = DATADIR "/" PACKAGE_NAME "/" "/kampagnen";

	boost::filesystem::directory_iterator end;

	for (boost::filesystem::directory_iterator it = 
				boost::filesystem::directory_iterator(boost::filesystem::path(Folder) );
			it != end;
			it++)
	{
		if (it->path().leaf().find(".ssk") == std::string::npos)
			continue;

		CampaignName = it->path().leaf();
		CampaignName.erase(CampaignName.length() - 4,4);

		m_ListField.AddEntry(CampaignName);
	}
}


void CMenu::ChangeSubMenuToLoad()
{
	m_CurSubMenu = MENU_SUB_LOAD;

	m_SaveListField.Clear();
	m_SaveListField.SetScroll(0);

	CSaveManager Manager;
	Manager.ReadSavesFromFolder("saves");

	m_LoadSpriteUp.SetPosition(m_LoadSpriteUp.GetPosition().x, 630);	
	m_LoadSpriteDown.SetPosition(m_LoadSpriteUp.GetPosition().x, m_LoadSpriteUp.GetPosition().y);	


	sf::Sprite m_CreditsSpriteUp;  //Das Credits Bild
	sf::Sprite m_CreditsSpriteDown;  //Das gedrückte Credits Bild

	std::size_t CurSave = 0;

	SaveData* Data;

	for(CurSave = 0; CurSave < Manager.GetSaveCount(); CurSave++)
	{
		Data = Manager.GetSaveData(CurSave);
		if(Data == NULL)
		{
			continue;
		}

		m_SaveListField.AddEntry(Data->ListName);
	}
}

std::string CMenu::GetCurSaveName()
{
	CSaveManager Manager;
	Manager.ReadSavesFromFolder("saves");

	int CurSave = m_SaveListField.GetCurSelectIndex();

	SaveData* Data;
	Data = Manager.GetSaveData(CurSave);

	if(Data == NULL)
	{
		return "";
	}

	return Data->SaveFile;
}
