/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KAMPAGNE_H
#define KAMPAGNE_H

#include <string>
#include <list>
#include <cstdio>
#include <iostream>
#include <log4cxx/logger.h>


#include "Mission.hpp"
#include "XML-Errors.hpp"

/** \brief Kampagne
  * \author Christoph Egger
  */
class CKampagne
{
	std::list<CMission*> m_Missions;
	std::list<CMission*>::iterator m_ActualMission;
	errorCode readFile(std::string Filename);
	std::string m_Intro;
	std::string m_ImgFile;
	int m_framecount;
	int m_framedelay;
	std::string m_Epilog;
	std::string m_Niederlage;
	std::string m_Title;
	int m_leben;
	void clearMissions();

	log4cxx::LoggerPtr log_;
public:
	CKampagne() : log_(log4cxx::Logger::getLogger("kampagne")) {}
	bool init(std::string filename);
	CMission* get_Mission() const
		{if(*m_ActualMission != NULL) return *m_ActualMission; else return NULL;}
	bool nextMission();
	std::string get_Intro()
		{return m_Intro;}
	std::string get_Epilog()
		{return m_Epilog;}
	std::string get_Niederlage()
		{return m_Niederlage;}
	std::string get_ImgFile()
		{return m_ImgFile;}
	std::string get_Title()
		{return m_Title;}
	int getLeben()
		{return m_leben;}
	int getFramecount()
		{return m_framecount;}
	int getFramedelay()
		{return m_framedelay;}
	std::size_t get_MissionIndex();
	bool set_MissionIndex(int index);
};





#endif
