/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "HUD-Manager.hpp"
#include "Singletons.hpp"

void CHUDManager::init(global_data_pointers pointers, CBitmapFont* bmFont)
{
	m_data = pointers;
	m_Background->SetImage(sgl::get_imagemgr().get_img("gfx/HUD_FLAECHE.png"));
	m_Background->SetPosition(SCREEN_X_SIZE - HUD_SIZE_X, 0);
	m_Background->SetScale(1.0, SCREEN_Y_SIZE);


}

AHUDElement* CHUDManager::registerHUD(bool* play_Info, std::list<SInfo*>* Infos, CBitmapFont* bmFont)
{
	CHUDInfo* element;
	element = new CHUDInfo(m_data, bmFont);
	element->init(play_Info, Infos);
	m_Elemente.push_back(element);
	return element;
}

AHUDElement* CHUDManager::registerHUD(int maxValue, const int* ActualValue, HUDType Type, int posX, int posY, int width, int height, int size)
{
	AHUDPoll* element;

	if (Type == POLL_GRAFIK_HORZ)
	{
		element = new CHUDPollGrafikHorz(m_data);
		element->SetPosition(posX, posY);
		element->SetSize(width, height);
		element->init(maxValue, ActualValue);
		m_Elemente.push_back(element);
	}
	else if (Type == POLL_GRAFIK_VERT)
	{
		element = new CHUDPollGrafikVert(m_data);
		element->SetPosition(posX, posY);
		element->SetSize(width, height);
		element->init(maxValue, ActualValue);
		m_Elemente.push_back(element);
	}
	else
		return NULL;
	return element;
}

AHUDElement* CHUDManager::registerHUD(float maxValue, const float* ActualValue, HUDType Type, int posX, int posY, int width, int height, int size)
{
	AHUDPoll* element;

	if (Type == POLL_GRAFIK_HORZ)
	{
		element = new CHUDPollGrafikHorz(m_data);
		element->SetPosition(posX, posY);
		element->SetSize(width, height);
		element->init(maxValue, ActualValue);
		m_Elemente.push_back(element);
	}
	else if (Type == POLL_GRAFIK_VERT)
	{
		element = new CHUDPollGrafikVert(m_data);
		element->SetPosition(posX, posY);
		element->SetSize(width, height);
		element->init(maxValue, ActualValue);
		m_Elemente.push_back(element);
	}
	else
		return NULL;
	return element;
}

AHUDElement* CHUDManager::registerHUD(const std::string* data, HUDType Type, int posX, int posY, CBitmapFont* bmFont, int fontsize, int size)
{
	CHUDPollText* element(0);
	if(Type == POLL_TEXT)
	{
		element = new CHUDPollText(bmFont, fontsize, size);
		element->SetPosition(posX, posY);
		element->init(data);
		m_Elemente.push_back(element);
		return NULL;
	}
	return element; /// \todo ???
}

std::string* CHUDManager::registerHUD(int posX, int posY, CBitmapFont *bmFont, HUDType Type, int size)
{
	CHUDSetText* element;
	if(Type == SET_TEXT)
	{
		element = new CHUDSetText(bmFont, size);
		element->SetPosition(posX, posY);
		std::string* temp = element->init();
		m_Elemente.push_back(element);
		return temp;
	}
	return NULL;
}


void CHUDManager::draw()
{
	sgl::get_window().Draw(*m_Background);
	std::list<AHUDElement*>::iterator iterator;
	iterator = m_Elemente.begin();
	while (iterator != m_Elemente.end())
	{
		(*iterator)->draw();
		iterator++;
	}
}

CHUDManager::~CHUDManager()
{
	std::list<AHUDElement*>::iterator iterator = m_Elemente.begin();
	while(iterator != m_Elemente.end())
	{
		delete *iterator;
		m_Elemente.erase(iterator++);
	}	
}
