/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "HUD-Element.hpp"
#include "UpdateFrame.hpp"

#include <log4cxx/logger.h>


#include <libintl.h>
#define _(string) gettext(string)

//AHUDElement

void AHUDElement::SetPosition(int X, int Y)
{
	m_X = X;
	m_Y = Y;
}

void AHUDElement::SetSize(int Width, int Height)
{
	m_Height = Height;
	m_Width = Width;
}

//AHUDPoll

void AHUDPoll::init(float maxValue, const float *aktuell)
{
	m_fAktuell = aktuell;
	m_ValueType = FLOAT;
	m_maxValue = maxValue;
	initChild();
}

void AHUDPoll::init(int maxValue, const int *aktuell)
{
	m_iAktuell = aktuell;
	m_ValueType = INTEGER;
	m_maxValue = maxValue;	
	initChild();
}

//CHUDPollGrafik

CHUDPollGrafikHorz::CHUDPollGrafikHorz(global_data_pointers data)
{
	m_Sprite = new sf::Sprite;
	m_Sprite->SetImage(sgl::get_imagemgr().get_img("gfx/LifelineHorz.png"));/// \todo, 1, 50, 1);
}

void CHUDPollGrafikHorz::initChild()
{
	m_Sprite->SetPosition(m_X, m_Y);
}

void CHUDPollGrafikHorz::draw()
{
	//char buffer[255];

	float Aktuell = ((m_ValueType == FLOAT) ? *m_fAktuell : (float)*m_iAktuell);
	float percentage = Aktuell / m_maxValue;
	float scalefactor = percentage * m_Width;
	float adapt = (float)m_Height / 50;
	m_Sprite->SetScale(scalefactor, adapt);
	sgl::get_window().Draw(*m_Sprite);
}


CHUDPollGrafikVert::CHUDPollGrafikVert(global_data_pointers data)
		: m_Sprite(new sf::Sprite)
{
	m_Sprite->SetImage(sgl::get_imagemgr().get_img("gfx/LifelineVert.png"));/// \todo, 50, 1, 1);
}

void CHUDPollGrafikVert::initChild()
{
	m_Sprite->SetPosition(m_X, m_Y);
}

void CHUDPollGrafikVert::draw()
{
	float Aktuell = ((m_ValueType == FLOAT) ? *m_fAktuell : (float)*m_iAktuell);
	float percentage = Aktuell / m_maxValue;
	float scalefactor = percentage * m_Height;
	float adapt = (float)m_Width / 50;
	m_Sprite->SetScale(adapt, scalefactor);
	sgl::get_window().Draw(*m_Sprite);
}

//CHUDPollText

void CHUDPollText::init(const std::string *data)
{
	m_Data = data;
}

void CHUDPollText::draw()
{
	m_bmFont->DrawText(m_X, m_Y, *m_Data, m_fontsize, m_textwidth);
}


//CHUDSetText

void CHUDSetText::draw()
{
	m_bmFont->DrawText(m_X, m_Y, m_Data, m_fontsize);
}

//CHUDInfo

void CHUDInfo::init(bool* show, std::list<SInfo*>* Infos)
{
	m_timer = 0;
	m_backg = new sf::Sprite();
	p_show = show;
	p_Infos = Infos;

	m_backg->SetImage(sgl::get_imagemgr().get_img("gfx/Infobgrnd.png"));
	m_image = new sf::Sprite();
	m_backg->SetPosition(162, 5);
	m_backg->SetColor(sf::Color(255, 255, 255, 0));
}

void CHUDInfo::draw()
{
	if (!(*p_show) || p_Infos->size() == 0) return;

	static unsigned char frame = 0;

	int alpha = 255;
	if (m_timer == 0)
	{
		m_image->SetImage(sgl::get_imagemgr().get_img((*(p_Infos->begin()))->image));
		m_image->SetSubRect(sf::IntRect(0, 0, 120, 120));
		/// \todo, 120, 120, (*(p_Infos->begin()))->framecount);
		m_image->SetPosition(192, 35);
		m_image->SetColor(sf::Color(255, 255, 255, 0));
		++m_timer;
	}
	if (m_timer < 127)
	{
		alpha = (m_timer*2);
	}
	else if (m_timer > 511)
	{	
		if (p_Infos->size() > 1)
		{
			p_Infos->pop_front();
			m_image->SetImage(sgl::get_imagemgr().get_img((*(p_Infos->begin()))->image));
			m_image->SetSubRect(sf::IntRect(0, 0, 120, 120));
			/// \todo(*(p_Infos->begin()))->framecount);
			m_timer = 126;
		}
		else
		{
			alpha = 1277 - (m_timer*2);
		}
	}
	if (m_timer > 638)
	{
		m_timer = 0;
		*p_show = false;
		if(p_Infos->size() == 1)
		{
			p_Infos->pop_front();
		}
		else
		{
			static log4cxx::LoggerPtr log_ (log4cxx::Logger::getLogger("CHUDInfo.draw"));
			LOG4CXX_ERROR(log_, _("Grave error"));
		}
	}
	else 
	{
		m_timer++;

		if (alpha > 255) alpha = 255;
		if (alpha < 0) alpha = 0;
		m_backg->SetColor(sf::Color(255, 255, 255, alpha));
		sgl::get_window().Draw(*m_backg);

		m_image->SetColor(sf::Color(255, 255, 255, alpha));
		sgl::get_window().Draw(*m_image);

		if ((frame++)%((*(p_Infos->begin()))->frameofset) == 0)
			update_frame(*m_image, (*(p_Infos->begin()))->framecount);

		m_bmFont->DrawText(335, 35, (*(p_Infos->begin()))->content, 16, 370, 120, 0, NULL, alpha);
	}
}
