/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
Christoph Egger
EnemyManager
Verwaltung der NPCs
*/

#ifndef ENEMYMANAGER_H
#define ENEMYMANGER_H

//std - Include
#include <list>
#include <string>
#include <bitset>
#include <log4cxx/logger.h>

//Projekt - Include
#include "Enemy_Help.hpp"
#include "Enemy.hpp"
#include "Ally.hpp"
#include "Player.hpp"
#include "PowerUp.hpp"
#include "XML-Errors.hpp"

/** \brief Verwaltung der NPCs
  * \author Christoph Egger
  */
class CEnemyManager
{
	struct S_no_fight
	{
		int begin, end;
	};

	struct less_S_no_fight
		: public std::binary_function<S_no_fight, S_no_fight, bool>
	{
		bool operator()(const S_no_fight& x, const S_no_fight& y) const {return x.begin < y.begin;}
	};

	std::bitset<(SCREEN_X_SIZE - HUD_SIZE_X)> m_owned_enemy;
	std::bitset<(SCREEN_X_SIZE - HUD_SIZE_X)> m_owned_ally;
	std::bitset<(SCREEN_X_SIZE - HUD_SIZE_X)> m_bs_empty;

	std::list<ANPC*> m_ActiveEnemys;
	std::list<ANPC*> m_PassiveEnemys;

	std::list<S_no_fight> m_no_fight;

	std::list<ANPC*> m_ActiveAllys;
	std::list<ANPC*> m_PassiveAllys;

	std::list<projectileData> m_regProjectiles_Ally;
	std::list<projectileData> m_regProjectiles_Enemy;

	std::list<CPowerUp*> m_PowerUps;

	std::list<ANPC*>::iterator m_NextToEvaluate_Enemy;
	std::list<ANPC*>::iterator m_NextToEvaluate_Ally;

	std::list<SInfo*> m_Infos;

	//Sorgt dafür, dass immer nur 1 Boss oder m_max_power Enemys gleichzeitig aktiv sind
	int m_max_power;
	int m_activePower;
	float m_fancy[(SCREEN_X_SIZE - HUD_SIZE_X)];
	int m_activeWave;

	//Für die einblendung von zusatzinformationen
	bool* p_blend;
	std::list<SInfo*>* p_Infos;

	AI_parameter* parameter;

	strength m_strength[10];

	global_data_pointers m_Data;

	CPlayer *player;

	log4cxx::LoggerPtr log_;

	errorCode readFile(std::string filename);

	errorCode readParameter(std::string filename);

	void registerProjectiles(std::list<ANPC*>& source, std::list<projectileData>& dest);
	void registerProjectiles();

	void update_owned(std::list<ANPC*>& source, std::bitset<(SCREEN_X_SIZE - HUD_SIZE_X)>& dest);
	void update_owned();
	

public:
	CEnemyManager()
			: m_max_power(4),
			  parameter(NULL),
			  player(NULL),
 			  log_(log4cxx::Logger::getLogger("EnemyManager"))
	{}

	bool reset();
	int clearPowerups();
	bool init(std::string filename_waves, std::string filename_parameter, global_data_pointers Data, CPlayer *player, bool* play_Info, std::list<SInfo*>* Infos);
	bool update();
	bool hasWon()
		{if (m_ActiveEnemys.size() == 0 && m_PassiveEnemys.size() == 0 && m_Infos.size() == 0 && !*p_blend) return true; return false;}
	strength* getStrength(int level);
		
};










#endif
