/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Enemy.hpp"
#include "MathFuncs.hpp"

bool CEnemy::calculate_y(float* down_up)
{
	//Fals sich das Schiff im y-Bereich außerhalb der Begrenzung befindet wird gegengesteuert, eine Berechnung ist nicht nötig
	if (m_Ship->GetYPosition() > SCREEN_Y_SIZE + 4) 
	{
		des_y = -1;
		return false;
	}
	if (m_Ship->GetYPosition() < -4) 
	{
		des_y = 1;
		return false;
	}

	//falls sich das Schiff bereits hinter dem Spieler befindet wird ebenfalls gegengesteuert, eine Berechnung ist nicht nötig
	int distance = m_player->GetYPosition() - m_Ship->GetYPosition();

	if(distance < 0)
	{
		des_y = -1;
		return false;
	}

	//Kontrolle der y-Position im Vergleich zur angestrebten

	float tmp = distance - desired_distance;
	
	if (abs(tmp) < m_parameter->sensibility_y)
	{
		down_up[0] = -50;
		down_up[1] = -50;
		return true;
	}
	if (sgn(tmp) > 0)
	{
		down_up[0] = abs(tmp);
		down_up[1] = -abs(tmp);
		return true;
	}
	else
	{
		down_up[0] = -abs(tmp);
		down_up[1] = abs(tmp);
		return true;
	}
}


void CEnemy::number_enemys(int* results, std::list<ANPC*>& r_Enemys)
{
	std::list<ANPC*>::iterator ship = r_Enemys.begin();
	while (ship != r_Enemys.end())
	{
		if ((*ship)->getShip()->GetXPosition() > m_Ship->GetXPosition() + m_Ship->GetCollisionSystemWidth()/2 + m_weapon_offset)
		{
			results[2]++;
		}
		else if ((*ship)->getShip()->GetXPosition() < m_Ship->GetXPosition() - m_Ship->GetCollisionSystemWidth()/2 + m_weapon_offset)
		{
			results[0]++;
		}
		else
		{
			results[1]++;
		}
		ship++;
	}
	if (m_player->GetShip()->GetXPosition() > m_Ship->GetXPosition() + m_Ship->GetCollisionSystemWidth()/2)
	{
		++(++results[2]);
	}
	else if (m_player->GetShip()->GetXPosition() < m_Ship->GetXPosition() - m_Ship->GetCollisionSystemWidth()/2)
	{
		++(++results[0]);
	}
	else
	{
		++(++results[1]);
	}
}
