/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Emiter.h - Deklaration der Klasse CEmiter
//CEmiter wird für das verwalten von PartikelEmitern benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef EMITER_H
#define EMITER_H

#include "Globals.hpp"
#include "Particle.hpp"

#include <vector>
#include <string>


//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Partikel Emitter
  * \author Steffen Nörtershäuser
  */
class CEmiter
{
public:
	/// Konstruktor und Destruktor
	CEmiter();
	~CEmiter();

	/// Diese Funktion intialisiert den Emiter
	void Init(const std::string& TexName, float FrameWidth = -1, float FrameHeight = -1, int FrameCount = 1);


	/// Diese Funktion intialisiert den Emiter aus der angebenen Datei
	void InitFromFile(const std::string& FileName);

	/// Diese Funktion aktiviert den Emiter
	void Activate(bool Activate = true) { m_Active = Activate; }

	/// Diese Funktion gibt zurück ob der Emiter aktiv ist
	bool IsActivate() const { return m_Active; }


	/// Diese Funktion legt die EmiterPosition fest
	void SetPosition(float X, float Y)
	{
		m_X = X;
		m_Y = Y;
	}

	/// Diese Funktion gibt die X-Position zurück
	float GetXPosition() const { return m_X; }

	/// Diese Funktion gibt die Y-Position zurück
	float GetYPosition() const { return m_Y; }
	
	/// Diese Funktion legt die Größe des Emiters fest
	void SetSize(float X, float Y)
	{
		m_HalfXSize = X / 2;
		m_HalfYSize = Y / 2;
	}

	/// Diese Funktion gibt die X-Größe des Emiters zurück
	float GetXSize() const { return 2.0f*m_HalfXSize; }

	/// Diese Funktion gibt die Y-Größe des Emiters zurück
	float GetYSize() const { return 2.0f*m_HalfYSize; }
	
	/// Diese Funktion aktualisiert den Emiter
	void Update();

	/// Diese Funktion zeichnet die Partikel des Emiters
	void Draw();

	/// Diese Funktion gibt die Anzahl der Partikel des Emiters zurück
	int GetParticleCount() const { return m_Particels.size(); }

	/// Diese Funktion legt die Zeit die zwischen dem erstellen von 2 Partikeln gewaretet wird fest
	void SetSpawnDelay(int SpawnDelay) { m_SpawnDelay = SpawnDelay; }

	/// Diese Funktion gibt die Zeit die zwischen dem erstellen von 2 Partikeln gewaretet wird zurück
	int GetSpawnDelay() const { return m_SpawnDelay; }


	/// Diese Funktion legt die Zeit in Millisekunden die zwischen dem inkrementieren der PartikelFrames gewartet wird fest
	void SetFrameDelay(int FrameDelay) { m_FrameDelay = FrameDelay; }

	/// Diese Funktion gibt die Zeit in Millisekunden die zwischen dem inkrementieren der PartikelFrames gewartet wird zurück
	int GetFrameDelay() const { return m_FrameDelay; }


	/// Diese Funktion legt die Lebensspanne der Partikel fest
	void SetLifeSpan(int LifeSpan) { m_ParticleLifeSpan = LifeSpan; }

	/// Diese Funktion gibt die Lebensspanne der Partikel zurück
	int GetLifeSpan() const { return m_ParticleLifeSpan; }


	/// Diese Funktion legt die StartSkalirung der Partikel fest
	void SetStartScale(float ScaleX, float ScaleY)
	{
		m_StartScaleX = ScaleX;
		m_StartScaleY = ScaleY;
	}

	/// Diese Funktion gibt die X-Achsen Startskalriung der Partikel zurück
	float GetStartScaleX() const { return m_StartScaleX; }

	/// Diese Funktion gibt die Y-Achsen Startskalriung der Partikel zurück
	float GetStartScaleY() const { return m_StartScaleY; }


	/// Diese Funktion legt die StartSkalirung der Partikel fest
	void SetTargetScale(float ScaleX, float ScaleY)
	{
		m_TargetScaleX = ScaleX;
		m_TargetScaleY = ScaleY;
	}

	/// Diese Funktion gibt die X-Achsen Zielskalriung der Partikel zurück
	float GetTargetScaleX() const { return m_TargetScaleX; }

	/// Diese Funktion gibt die Y-Achsen Zielskalriung der Partikel zurück
	float GetTargetScaleY() const { return m_TargetScaleY; }

	
	/// Diese Funktion legt den StartAlpha wert der Partikel fest
	void SetStartAlpha(int Alpha) { m_StartAlpha = Alpha; }

	/// Diese Funktion gibt den StartAlpha wert der Partikel zurück
	int GetStartAlpha() const { return m_StartAlpha; }


	/// Diese Funktion legt den StartAlpha wert der Partikel fest
	void SetEndAlpha(int Alpha) { m_EndAlpha = Alpha; }

	/// Diese Funktion gibt den StartAlpha wert der Partikel zurück
	int GetEndAlpha() const { return m_EndAlpha; }


	/// Diese Funktion legt die StartFarbwerte der Partikel fest
	void SetStartColor(int r, int g, int b)
	{
		m_StartRed = r;
		m_StartGreen = g;
		m_StartBlue = b;
	}

	/// Diese Funktion gibt den StartRot wert der Partikel zurück
	int GetStartColorR() const { return m_StartRed; }

	/// Diese Funktion gibt den StartGrün wert der Partikel zurück
	int GetStartColorG() const { return m_StartGreen; }
	
	/// Diese Funktion gibt den StartBlau wert der Partikel zurück
	int GetStartColorB() const { return m_StartBlue; }


	/// Diese Funktion legt die EndFarbwerte der Partikel fest
	void SetEndColor(int r, int g, int b)
	{
		m_EndRed = r;
		m_EndGreen = g;
		m_EndBlue = b;
	}

	/// Diese Funktion gibt den EndRot wert der Partikel zurück
	int GetEndColorR() const { return m_EndRed; }

	/// Diese Funktion gibt den EndGrün wert der Partikel zurück
	int GetEndColorG() const { return m_EndGreen; }
	
	/// Diese Funktion gibt den EndBlau wert der Partikel zurück
	int GetEndColorB() const { return m_EndBlue; }


	/// Diese Funktion legt die Startgeschwindigkeit der Partikel fest
	void SetStartVelX(float StartVelX) { m_StartVelX = StartVelX; }

	/// Diese Funktion gibt die Startgeschwindigkeit der Partikel zurück
	float GetStartVelX() const { return m_StartVelX; }

	
	/// Diese Funktion legt die Endgeschwindigkeit der Partikel fest
	void SetEndVelX(float EndVelX) { m_EndVelX = EndVelX; }

	/// Diese Funktion gibt die Endgeschwindigkeit der Partikel zurück
	float GetEndVelX() const { return m_EndVelX; }


	/// Diese Funktion legt die Startgeschwindigkeit der Partikel fest
	void SetStartVelY(float StartVelY) { m_StartVelY = StartVelY; }

	/// Diese Funktion gibt die Startgeschwindigkeit der Partikel zurück
	float GetStartVelY() const { return m_StartVelY; }

	
	/// Diese Funktion legt die Endgeschwindigkeit der Partikel fest
	void SetEndVelY(float EndVelY) { m_EndVelY = EndVelY; }

	/// Diese Funktion gibt die Endgeschwindigkeit der Partikel zurück
	float GetEndVelY() const { return m_EndVelY; }


	/// Diese Funktion legt die Mulitplikationen der Geschwindigkiet auf der X-Achse fest
	void SetVelXMulti(float Low, float High)
	{
		m_LowVelXMulti = Low;
		m_HighVelXMulti = High;
	}

	/// Diese Funktion gibt die untere Multiplikation der Geschwindigkiet auf der X-Achse zurück
	float GetLowVelXMulti() const { return m_LowVelXMulti; }

	/// Diese Funktion gibt die obere Multiplikation der Geschwindigkiet auf der X-Achse zurück
	float GetHighVelXMulti() const { return m_HighVelXMulti; }


	/// Diese Funktion legt die Mulitplikationen der Geschwindigkiet auf der Y-Achse fest
	void SetVelYMulti(float Low, float High)
	{
		m_LowVelYMulti = Low;
		m_HighVelYMulti = High;
	}

	/// Diese Funktion gibt die untere Multiplikation der Geschwindigkiet auf der Y-Achse zurück
	float GetLowVelYMulti() const { return m_LowVelYMulti; }

	/// Diese Funktion gibt die obere Multiplikation der Geschwindigkiet auf der Y-Achse zurück
	float GetHighVelYMulti() const { return m_HighVelYMulti; }
private:
	/// Diese Funktion erstellt einen neuen Partikel
	void SpawnNewParticle();

	std::vector<CParticle*> m_Particels;	//Die Partikel des Emiters

	std::string m_TexName;				//Der Name der Partikel Texturen

	bool m_Active;					//Ob der Emiter aktiv ist, d.h. ob Partikel erstellt werden

	float m_FrameWidth;				//Die Framebreite der PartikelBilder
	float m_FrameHeight;			//Die Framebreite der PartikelBilder
	int	  m_FrameCount;				//Die FrameAnzahl der PartikelBilder
	int   m_FrameDelay;				//Die Zeit die zwischem dem inkrementieren eines Frames gewartet wird

	float m_X;						//Die X-Position des Emiters
	float m_Y;						//Die Y-Position des Emiters

	float m_HalfXSize;				//Die Halbe X-Größe des Emiters
	float m_HalfYSize;				//Die Halbe X-Größe des Emiters

	float m_StartScaleX;			//Die Startskalirung der Partikel auf der X-Achse
	float m_StartScaleY;			//Die Startskalirung der Partikel auf der Y-Achse

	float m_TargetScaleX;			//Die Endskalirung der Partikel auf der X-Achse
	float m_TargetScaleY;			//Die Endskalirung der Partikel auf der Y-Achse	

	int m_StartAlpha;				//Der StartAlpha wert der Partikel
	int m_EndAlpha;					//Der EndAlpha wert der Partikel

	int m_StartRed;					//Der StartRot Wert der Partikel
	int m_EndRed;					//Der EndRot Wert der Partikel

	int m_StartGreen;				//Der StartGrün Wert der Partikel
	int m_EndGreen;					//Der EndGrün Wert der Partikel

	int m_StartBlue;				//Der StartBlau Wert der Partikel
	int m_EndBlue;					//Der EndBlau Wert der Partikel

	float m_StartVelX;				//Die Startgeschwindigkeit der Partikel auf der X-Achse
	float m_EndVelX;				//Die Endgeschwindigkeit der Partikel auf der X-Achse

	float m_StartVelY;				//Die Startgeschwindigkeit der Partikel auf der Y-Achse
	float m_EndVelY;				//Die Endgeschwindigkeit der Partikel auf der Y-Achse

	float m_LowVelXMulti;			//Zwischen diesen beiden Werten werden Zufallszahlen erzeugt und mit der X-Geschwindigkeit 
	float m_HighVelXMulti;			//mulitpliziert

	float m_LowVelYMulti;			//Zwischen diesen beiden Werten werden Zufallszahlen erzeugt und mit der Y-Geschwindigkeit 
	float m_HighVelYMulti;			//mulitpliziert

	int m_LastSpawn;				//Die Millisekunden als das letze mal ein Partikel erstellt wurde
	int m_SpawnDelay;				//Wieviele Millisekunden zwischen dem erstellen zweier Partikel gewaretet wird

	int m_ParticleLifeSpan;			//Die Lebensspanne der Partikel in Millisekunden
};

#endif
