/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Emitter.hpp"
#include "Singletons.hpp"
#include "MathFuncs.hpp"

CEmiter::CEmiter()
		: m_Active(true),
		  m_FrameWidth(-1.0f),
		  m_FrameHeight(-1.0f),
		  m_FrameCount(1),
		  m_FrameDelay(1000),
		  m_X(0.0f),
		  m_Y(0.0f),
		  m_HalfXSize(0.0f),
		  m_HalfYSize(0.0f),
		  m_StartScaleX(1.0f),
		  m_StartScaleY(1.0f),
		  m_TargetScaleX(1.0f),
		  m_TargetScaleY(1.0f),
		  m_StartAlpha(255),
		  m_EndAlpha(255),
		  m_StartRed(255),
		  m_EndRed(255),
		  m_StartGreen(255),
		  m_EndGreen(255),
		  m_StartBlue(255),
		  m_EndBlue(255),
		  m_StartVelX(0.0f),
		  m_EndVelX(0.0f),
		  m_LowVelXMulti(1.0f),
		  m_HighVelXMulti(1.0f),
		  m_LowVelYMulti(1.0f),
		  m_HighVelYMulti(1.0f)
{}

CEmiter::~CEmiter()
{
	for(std::size_t CurParticle = 0; CurParticle < m_Particels.size(); CurParticle++)
	{
		delete m_Particels[CurParticle];
	}
	m_Particels.clear();
}

void CEmiter::Init(const std::string& TexName, float FrameWidth, float FrameHeight, int FrameCount)
{
	m_TexName		= TexName;

	m_FrameWidth	= FrameWidth;
	m_FrameHeight	= FrameHeight;
	m_FrameCount	= FrameCount;
}

void CEmiter::InitFromFile(const std::string& FileName)
{
	char strBuf[100];
	std::string HelpString;
	std::string OldString;


	FILE* EmiterFile = fopen( ( std::string(DATADIR "/" PACKAGE_NAME "/") + FileName ).c_str(),"r");
	if(EmiterFile == NULL)
	{
		return;
	}

	while(feof(EmiterFile) == 0)
	{
		fscanf(EmiterFile,"%s",strBuf);
		HelpString = strBuf;

		if(HelpString == "=")
		{
			if(OldString == "Image")
			{
				fscanf(EmiterFile,"%s",strBuf);
				m_TexName = strBuf;
			}	
			else if(OldString == "FrameWidth")
			{
				fscanf(EmiterFile,"%f",&m_FrameWidth);
			}	
			else if(OldString == "FrameHeight")
			{
				fscanf(EmiterFile,"%f",&m_FrameHeight);
			}	
			else if(OldString == "FrameCount")
			{
				fscanf(EmiterFile,"%d",&m_FrameCount);
			}
			else if(OldString == "FrameDelay")
			{
				fscanf(EmiterFile,"%d",&m_FrameDelay);
			}

			else if(OldString == "XSize")
			{
				fscanf(EmiterFile,"%f",&m_HalfXSize);
				m_HalfXSize /= 2;
			}
			else if(OldString == "YSize")
			{
				fscanf(EmiterFile,"%f",&m_HalfYSize);
				m_HalfYSize /= 2;
			}

			else if(OldString == "LifeSpan")
			{
				fscanf(EmiterFile,"%d",&m_ParticleLifeSpan);
			}
			else if(OldString == "SpawnDelay")
			{
				fscanf(EmiterFile,"%d",&m_SpawnDelay);
			}

			else if(OldString == "StartAlpha")
			{
				fscanf(EmiterFile,"%d",&m_StartAlpha);
			}				
			else if(OldString == "EndAlpha")
			{
				fscanf(EmiterFile,"%d",&m_EndAlpha);
			}	

			else if(OldString == "StartColorR")
			{
				fscanf(EmiterFile,"%d",&m_StartRed);
			}	
			else if(OldString == "StartColorG")
			{
				fscanf(EmiterFile,"%d",&m_StartGreen);
			}			
			else if(OldString == "StartColorB")
			{
				fscanf(EmiterFile,"%d",&m_StartBlue);
			}	

			else if(OldString == "EndColorR")
			{
				fscanf(EmiterFile,"%d",&m_EndRed);
			}	
			else if(OldString == "EndColorG")
			{
				fscanf(EmiterFile,"%d",&m_EndGreen);
			}			
			else if(OldString == "EndColorB")
			{
				fscanf(EmiterFile,"%d",&m_EndBlue);
			}

			else if(OldString == "StartVelX")
			{
				fscanf(EmiterFile,"%f",&m_StartVelX);
			}
			else if(OldString == "StartVelY")
			{
				fscanf(EmiterFile,"%f",&m_StartVelY);
			}

			else if(OldString == "EndVelX")
			{
				fscanf(EmiterFile,"%f",&m_EndVelX);
			}
			else if(OldString == "EndVelY")
			{
				fscanf(EmiterFile,"%f",&m_EndVelY);
			}

			else if(OldString == "LowVelXMulti")
			{
				fscanf(EmiterFile,"%f",&m_LowVelXMulti);
			}
			else if(OldString == "HighVelXMulti")
			{
				fscanf(EmiterFile,"%f",&m_HighVelXMulti);
			}

			else if(OldString == "LowVelYMulti")
			{
				fscanf(EmiterFile,"%f",&m_LowVelYMulti);
			}
			else if(OldString == "HighVelYMulti")
			{
				fscanf(EmiterFile,"%f",&m_HighVelYMulti);
			}

			else if(OldString == "StartScaleX")
			{
				fscanf(EmiterFile,"%f",&m_StartScaleX);
			}
			else if(OldString == "EndScaleX")
			{
				fscanf(EmiterFile,"%f",&m_TargetScaleX);
			}

			else if(OldString == "StartScaleY")
			{
				fscanf(EmiterFile,"%f",&m_StartScaleY);
			}
			else if(OldString == "EndScaleY")
			{
				fscanf(EmiterFile,"%f",&m_TargetScaleY);
			}
		}

		OldString = HelpString;
	}

	fclose(EmiterFile);
}


void CEmiter::Update()
{
	if(sgl::get_clock().GetElapsedTime()*1000-m_LastSpawn > m_SpawnDelay && m_Active == true)
	{
		m_LastSpawn = sgl::get_clock().GetElapsedTime()*1000;

		SpawnNewParticle();
	}

	for(std::size_t CurParticle = 0; CurParticle < m_Particels.size(); CurParticle++)
	{
		m_Particels[CurParticle]->Update();

		if(m_Particels[CurParticle]->Remove() == true)
		{
			delete m_Particels[CurParticle];
			m_Particels.erase(m_Particels.begin() + CurParticle);
		}
	}
}

void CEmiter::Draw()
{
	for(std::size_t CurParticle = 0; CurParticle < m_Particels.size(); CurParticle++)
	{
		m_Particels[CurParticle]->Draw();
	}
}


void CEmiter::SpawnNewParticle()
{
	float Multi = 0.0f;
	float X = m_X + frnd(-m_HalfXSize,m_HalfXSize);
	float Y = m_Y + frnd(-m_HalfYSize,m_HalfYSize);

	CParticle* Particle = new CParticle;
	Particle->Init(m_TexName,m_FrameWidth,m_FrameHeight,m_FrameCount);
	Particle->SetLifeSpan(m_ParticleLifeSpan);
	Particle->SetPosition(X,Y);

	Particle->SetScale(m_StartScaleX,m_StartScaleY);
	Particle->SetTargetScale(m_TargetScaleX,m_TargetScaleY);

	Particle->SetStartAlpha(m_StartAlpha);
	Particle->SetEndAlpha(m_EndAlpha);

	Particle->SetStartRed(m_StartRed);
	Particle->SetEndRed(m_EndRed);

	Particle->SetStartGreen(m_StartGreen);
	Particle->SetEndGreen(m_EndGreen);
	
	Particle->SetStartBlue(m_StartBlue);
	Particle->SetEndBlue(m_EndBlue);

	Multi = frnd(m_LowVelXMulti,m_HighVelXMulti);
	Particle->SetStartVelX(m_StartVelX*Multi);
	Particle->SetEndVelX(m_EndVelX*Multi);

	Multi = frnd(m_LowVelYMulti,m_HighVelYMulti);
	Particle->SetStartVelY(m_StartVelY*Multi);
	Particle->SetEndVelY(m_EndVelY*Multi);

	Particle->SetAniSpeed(m_FrameDelay);

	m_Particels.push_back(Particle);
}
