/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//BitmapFont.h - Deklaration der Klasse CCreditsManager
//CCreditsManager wird für das Darstellen der Credits benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef CREDITSMANAGER_H
#define CREDITSMANAGER_H

/////////////////////////////Includes/////////////////////////////////////////////////////////////

#include "Globals.hpp"
#include "Bitmapfont.hpp"
#include "Ship.hpp"
#include <vector>
#include <string>

#define CREDITS_SIZE_UPDATE_SPEED 20
#define CREDITS_START_SIZE		  5
#define CREDITS_END_SIZE		  28
#define CREDITS_FADE_OUT_TIME	  5000
#define CREDITS_SPACE_X			  200
#define CREDITS_SPACE_SIDE		  250
#define CREDITS_Y_INFLUENCE		  250
#define CREDITS_Y_DAMAGE		  70

//////////////////////////////////////////////////////////////////////////////////////////////////

struct CreditsAsteroid
{
	CShip Ship;
	std::string Name;
	int TextSize;
	int LastSizeUpdate;
};

/** \brief Credits Manager
  * \author Steffen Nörtershäuser
  */
class CCreditsManager
{
public:
	//Konstruktur und Destruktor
	CCreditsManager();
	~CCreditsManager();

	//Diese Funktion intialisiert die Credits
	void Init(CBitmapFont* BitMapFont);

	//Diese Funktion zeichnet die Credits
	void Draw();

	//Diese Funktion gibt zurück ob die Credits beendet sind
	bool IsFinished() const { return m_Asteroids.size() == 0; }
private:
	//Diese Funktion gibt alles wieder frei
	void CleanUp();

	//Diese Funktion fügt einen Asteroiden hinzu
	void AddAsteroid(std::string Name, int YOff);

	std::vector<CreditsAsteroid*> m_Asteroids; //Die Asteroiden die zerschossen werden

	int m_CurName;					//Der momentan darzustellene Name
	CBitmapFont* m_BitMapFont;		//Der Bitmapfont zum Zeichnen der Namen

	CShip m_PlayerShip;				//Das Schiff das die Asteroiden zerschießt

	bool m_Finished;				//Ob die Credits vorbei sind
};
#endif

