/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "CreditsManager.hpp"
#include "Singletons.hpp"
#include "MathFuncs.hpp"

#include <cmath>
#include <libintl.h>
#define _(string) gettext(string)

CCreditsManager::CCreditsManager()
		: m_BitMapFont(NULL),
		  m_CurName(0)
{}

CCreditsManager::~CCreditsManager()
{
	CleanUp();
}

void CCreditsManager::CleanUp()
{
	for(std::size_t CurAsteroid = 0; CurAsteroid < m_Asteroids.size(); CurAsteroid++)
	{
		delete m_Asteroids[CurAsteroid];
	}
	m_Asteroids.clear();
}

void CCreditsManager::Init(CBitmapFont* BitMapFont)
{
	CleanUp();
		
	m_BitMapFont = BitMapFont;

	m_PlayerShip.Init(DATADIR "/" PACKAGE_NAME "/ships/Credits.txt");
	m_PlayerShip.SetPosition(SCREEN_X_SIZE/2,SCREEN_Y_SIZE + 100);

	AddAsteroid(_("Programming:"),50);
	AddAsteroid("Steffen Nörtershäuser",110);
	AddAsteroid("Christoph Egger",190);

	AddAsteroid(_("Graphics:"),650);
	AddAsteroid("Fabian Wächter",710);
	AddAsteroid("Steffen Nörtershäuser",830);
	AddAsteroid("Christoph Egger",910);
	AddAsteroid("Mats Witte",990);
	AddAsteroid("Lauritz Beck",1070);
	AddAsteroid("James Hastings-Trew",1150);
	AddAsteroid("http://planetpixelemporium.com/",1230);

	AddAsteroid(_("Music:"),1850);
	AddAsteroid("Devin Anderson",1930);
	AddAsteroid("http://www.devinanderson.com/",2010);

	AddAsteroid(_("Betatesting:"),2710);
	AddAsteroid("Michael Stiebert",2790);
}

void CCreditsManager::Draw()
{
	if(m_BitMapFont == NULL)
	{
		return;
	}

	m_PlayerShip.Draw();

	for(std::size_t CurAsteroid = 0; CurAsteroid < m_Asteroids.size(); CurAsteroid++)
	{
		if(m_Asteroids[CurAsteroid]->Ship.IsDead() == false)
		{
			m_Asteroids[CurAsteroid]->LastSizeUpdate = sgl::get_clock().GetElapsedTime()*1000;
			m_Asteroids[CurAsteroid]->Ship.MoveY(1);

			if(m_Asteroids[CurAsteroid]->Ship.GetYPosition() > CREDITS_Y_DAMAGE)
			{
				m_Asteroids[CurAsteroid]->Ship.SetInvulnerable(false);
			}

			m_PlayerShip.CheckCollision(&m_Asteroids[CurAsteroid]->Ship);
		}
		else
		{
			if(sgl::get_clock().GetElapsedTime()*1000 - m_Asteroids[CurAsteroid]->LastSizeUpdate > CREDITS_SIZE_UPDATE_SPEED)
			{
				m_Asteroids[CurAsteroid]->TextSize++;
				if(m_Asteroids[CurAsteroid]->TextSize > CREDITS_END_SIZE)
				{
					m_Asteroids[CurAsteroid]->TextSize = CREDITS_END_SIZE;
				}

				m_Asteroids[CurAsteroid]->LastSizeUpdate = sgl::get_clock().GetElapsedTime()*1000;
			}
		}
		m_Asteroids[CurAsteroid]->Ship.Draw();
	}

	for(std::size_t CurAsteroid = 0; CurAsteroid < m_Asteroids.size(); CurAsteroid++)
	{
		if(m_Asteroids[CurAsteroid]->Ship.IsDead() == false)
		{
			continue;
		}

		float Alpha = 255;
		Alpha = 1.0f - (sgl::get_clock().GetElapsedTime()*1000 - m_Asteroids[CurAsteroid]->Ship.GetDeadTime()) / CREDITS_FADE_OUT_TIME;
		Alpha *= 255;

		if(Alpha < 0.0f)
		{
			delete m_Asteroids[CurAsteroid];
			m_Asteroids.erase(m_Asteroids.begin() + CurAsteroid);
			continue;
		}

		m_BitMapFont->DrawText(m_Asteroids[CurAsteroid]->Ship.GetXPosition(),m_Asteroids[CurAsteroid]->Ship.GetYPosition(),
							   m_Asteroids[CurAsteroid]->Name,m_Asteroids[CurAsteroid]->TextSize, 10000.0f, 10000.0f, 0,
							   NULL, Alpha, true);
	}

	if(m_PlayerShip.GetYPosition() > SCREEN_Y_SIZE - 100)
	{
		m_PlayerShip.MoveY(-1);
	}

	if(m_Asteroids.size() == 0)
	{
		return;
	}
	
	int Index = -1;
	for(std::size_t CurAsteroid = 0; CurAsteroid < m_Asteroids.size(); CurAsteroid++)
	{
		if(m_Asteroids[CurAsteroid]->Ship.IsDead() == false && m_Asteroids[CurAsteroid]->Ship.GetYPosition() > -50)
		{
			Index = CurAsteroid;
			break;
		}
	}

	if(Index == -1)
	{
		return;
	}

	if (m_Asteroids[Index]->Ship.GetXPosition() > m_PlayerShip.GetXPosition() + m_PlayerShip.GetCollisionSystemWidth()/2)
	{
		m_PlayerShip.MoveX(1);
	}
	else if(m_Asteroids[Index]->Ship.GetXPosition() < m_PlayerShip.GetXPosition() - m_PlayerShip.GetCollisionSystemWidth()/2)
	{
		m_PlayerShip.MoveX(-1);
	}
	else
	{
		m_PlayerShip.Shoot();
	}
}

void CCreditsManager::AddAsteroid(std::string Name, int YOff)
{
	int X = 0;
	int Y = -(rand() % 50 + YOff);
	if(m_Asteroids.size() == 0)
	{
		X = SCREEN_X_SIZE / 2 - frnd(-50,50);
	}
	else
	{
		int OldX = m_Asteroids[m_Asteroids.size() - 1]->Ship.GetXPosition();
		
		if(OldX - CREDITS_SPACE_X < CREDITS_SPACE_SIDE)
		{
			X = frnd(OldX + CREDITS_SPACE_X, SCREEN_X_SIZE - CREDITS_SPACE_SIDE);
		}
		else if(OldX + CREDITS_SPACE_X > SCREEN_X_SIZE - CREDITS_SPACE_SIDE)
		{
			X = frnd(CREDITS_SPACE_SIDE, OldX - CREDITS_SPACE_X);
		}
		else
		{
			float Side = 0;
			float YWeigth = 0.0f;
			for(int CurAsteroid = 0; CurAsteroid < m_Asteroids.size() - 1; CurAsteroid++)
			{
				YWeigth = std::fabs(m_Asteroids[CurAsteroid]->Ship.GetYPosition() - Y) / CREDITS_Y_INFLUENCE;
				if(YWeigth > 1.0f)
				{
					continue;
				}
				YWeigth = 1.0f - YWeigth;

				if(m_Asteroids[CurAsteroid]->Ship.GetXPosition() > OldX)
				{
					Side += YWeigth;
				}
				else
				{
					Side -= YWeigth;
				}
			}

			if(Side > 0) //Links
			{
				X = frnd(CREDITS_SPACE_SIDE, OldX - CREDITS_SPACE_X);
			}
			else //Rechts
			{
				X = frnd(OldX + CREDITS_SPACE_X, SCREEN_X_SIZE - CREDITS_SPACE_SIDE);
			}
		}
	}
//	CREDITS_SPACE_X

	CreditsAsteroid* Asteroid = new CreditsAsteroid;
	Asteroid->Ship.Init(DATADIR "/" PACKAGE_NAME "/ships/CreditsAsteroid.txt");
	Asteroid->Ship.SetPosition(X, Y);
	Asteroid->Ship.SetInvulnerable(true);
	Asteroid->Name = Name;
	Asteroid->TextSize = CREDITS_START_SIZE;
	Asteroid->LastSizeUpdate = sgl::get_clock().GetElapsedTime()*1000;

	m_Asteroids.push_back(Asteroid);
}
