/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//CollisionSystem.h - Deklaration der Klasse CCollisionSystem
//CCollisionSystem wird für das erkennen von Kollisionen benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef COLLISIONSYSTEM_H
#define COLLISIONSYSTEM_H

#include "BoundingCircle.hpp"

#include <vector>
#include <string>

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Kollisionssystem
  * \author Steffen Nörtershäuser
  */
class CCollisionSystem
{
public:
	/// Konstrukor und Destruktor
	CCollisionSystem();
	~CCollisionSystem();

	/// Diese Funktion intialsiert das KollisionsSystem  aus der angeben Datei
	void Init(std::string FileName);

	/// Diese Funktion legt die Position des KollisionSystem fest
	void SetPosition(float X, float Y);

	/// Diese Funktion überprüft ob zwei BoundingCircle der angeben KollisionsSysteme miteinander kollidieren
	bool CheckCollision(const CCollisionSystem* CounterPart) const;

	/// Diese Funktion gibt diee Anzahl der BoundingCircles des KollisionsSystems zurück
	std::size_t GetCircleCount() const { return m_Circles.size(); }

	//Diese Funktion gibt einen Pointer auf den BoundingCirlce am angeben Index zurück
	const CBoundingCircle* GetCircle(int Index) const { return m_Circles[Index]; }

	//Diese Funktion gibt die Breite des KollisionSystems zurück
	float GetWidth() const;


	void Draw()
	{}

private:
	std::vector<CBoundingCircle*> m_Circles;	//Die BoundingCircles
};

#endif
