/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Briefing.h - Deklaration der Klasse CBriefing
//CBriefing wird für das Verwalten und Darstellen von Briefings benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef BRIEFING_H
#define BRIEFING_H

#include "Globals.hpp"
#include "Bitmapfont.hpp"
#include "MenuListField.hpp"
#include "SaveManager.hpp"
#include "Player.hpp"

#include <string>
#include <SFML/Graphics.hpp>

static const unsigned BRIEF_SCROLL_DELAY = 200;

static const unsigned BRIEF_BUTTON_START = 0;
static const unsigned BRIEF_BUTTON_CANCEL = 1;
static const unsigned BRIEF_BUTTON_FINISH = 2;

static const unsigned BRIEF_SUB_START = 0;
static const unsigned BRIEF_SUB_SAVE = 1;

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Briefing
  * \author Steffen Nörtershäuser
  */
class CBriefing
{
public:
	/// Konstruktor und Destruktor
	CBriefing();
	~CBriefing();

	/// Diese Funktion intialisiert das Briefing
	void Init(CBitmapFont* BitMapFont, int* MouseX, int* MouseY, 
			  bool* MouseDown, CPlayer* Player);

	/// Diese Funktion legt den Title des Briefings, den Inhalt des Briefings und das Logo fest
	void SetContent(std::string Title, std::string Content, std::string FileName, 
			int ButtonType = BRIEF_BUTTON_START, unsigned int FrameCount = 1, int FrameDelay = 50);

	/// Diese Funktion öffnet das Menü
	void Update();

	/// Diese Funktion gibt zurück ob das Menü geschlossen werden soll
	bool Close() 
	{ 
		bool Close = m_Close;
		m_Close = false;
		return Close; 
	}

	/// Diese Funktion gibt den Button Type zurück
	int GetButtonType() const { return m_ButtonType; }

	/// Diese Funktion legt die aktuelle Kampagne fest
	void SetCampaign(std::string Campaign) { m_CampaignName = Campaign; }

	/// Diese Funktion gibt die aktuelle Kampagne zurück
	std::string GetCampaign() const { return m_CampaignName; }


	/// Diese Funktion legt die aktuelle Mission fest
	void SetCurMission(int Mission) { m_CurMission = Mission; }

	/// Diese Funktion inkrementiert die aktuelle Mission
	void IncCurMission() { m_CurMission++; }

	/// Diese Funktion gibt die aktuelle Mission zurück
	int GetCurMission() const { return m_CurMission; }

private:
	//Diese Funktion zeichnet alles
	void RenderAll();

	//Diese Funktion zeichnet alles was zum Starten gehöhrt
	void RenderStart();

	//Diese Funktion zeichnet alles was zum Laden gehöhrt
	void RenderLoad();


	//Diese Funktion überprüft ob ein Button gedrückt wurde usw.
	bool UpdateAll();


	//Diese Funktion wechselt das UnterMenü zu speichern
	void ChangeToSave();

	//Diese Funktion wechselt das UnterMenü zu starten
	void ChangeToStart();


	//Diese Funktion speichert
	void Save();

	//Diese Funktion füllt die SaveListe
	void FillSaveList();

	CBitmapFont* m_BitmapFont; //Der Bitmapfont zum Text darstellen

	CPlayer* m_Player;		//Der Spieler

	sf::Sprite* m_LogoSprite;  //Das Logo des Sprites
	unsigned int frame_count;
	int m_LastFrameInc;		//Wann das letze mal der Frame erhöht wurde
	int m_FrameDelay;		//Wie lange gewartet werden soll beim erhöhen der Frames

	sf::Sprite m_BackSprite;	//Das Hintergrund Logo des Sprites

	sf::Sprite m_ScrollUp_Up;	 //Der Aktivierte Hoch-Scroll Button
	sf::Sprite m_ScrollUp_Down; //Der Aktivierte runtergedrückte Hoch-Scroll Button
	sf::Sprite m_ScrollUpDisable; //Der Ausgeschaltete Hoch-Scroll Button

	sf::Sprite m_ScrollDown_Up;	//Der Aktivierte Runter-Scroll Button
	sf::Sprite m_ScrollDown_Down; //Der Aktivierte runtergedrückte Runter-Scroll Button
	sf::Sprite m_ScrollDownDisable; //Der Ausgeschaltete Runter-Scroll Button

	sf::Sprite m_StartUp;		//Der Knopf zum Starten, wenn er nicht gedrückt ist
	sf::Sprite m_StartDown;	//Der Knopf zum Starten, wenn er gedrückt ist

	sf::Sprite m_SaveUp;		//Der Knopf zum Speichern, wenn er nicht gedrückt ist
	sf::Sprite m_SaveDown;		//Der Knopf zum Speichern, wenn er gedrückt ist

	sf::Sprite m_BackUp;		//Der Zurück-Knopf, wenn er nicht gedrückt ist
	sf::Sprite m_BackDown;		//Der Zurück-Knopf, wenn er gedrückt ist

	sf::Sprite m_CancelUp;		//Der Knopf zum Abbrechen, wenn er nicht gedrückt ist
	sf::Sprite m_CancelDown;	//Der Knopf zum Abbrechen, wenn er gedrückt ist

	sf::Sprite m_FinishUp;		//Der Knopf zum Abschließen, wenn er nicht gedrückt ist
	sf::Sprite m_FinishDown;	//Der Knopf zum Abschließen, wenn er gedrückt ist

	CMenuListField m_SaveField; //Das SpeichernListenfeld

	int m_SubMenu;			//Welcher Unterpunkt gerade ausgewählt ist

	int m_ButtonType;		//Welcher Button angezeigt werden soll

	int* m_MouseX;			//Die X-Koordinate der Maus
	int* m_MouseY;			//Die Y-Koordinate der Maus
	bool* m_MouseDown;		//Ob die Maus gedrückt wurde
	bool m_HasHitMouse;		//Ob die Maus gerade gedrückt wurde
	bool m_ButtonDown;		//Ob der Knopf gerade gedrückt wird

	bool m_SaveButtonDown;  //Ob der Speicher Knopf gerade gedrückt wird

	bool m_ScrollingUp;		//Ob gerade hochgescrollt wird
	bool m_ScrollingDown;	//Ob gerade runtergescrollt wird
	int  m_LastScrollTime;	//Wann das letze mal gescrollt wurde

	bool m_CanScrollDown;	//Ob runter gescrollt werden kann

	bool m_Close;			//Ob das Menü geschlossen werden soll

	std::string m_Title;			//Der Title des Briefings
	std::string m_Content;		//Der Inhalt des Briefings
	int m_ContentScroll;	//Um wieviele Zeilen der Inhalt des Briefings gescrollt werden soll

	std::string m_CampaignName;  //Der Name der momentanen Kampagne
	int m_CurMission;		//Die mometane Mission
};
#endif
