/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//BitmapFont.h - Deklaration der Klasse CBitmapFont
//CBitmapFont wird für das Darstellen BitmapFonts bentötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef BITMAPFONT_H
#define BITMAPFONT_H

/////////////////////////////Includes/////////////////////////////////////////////////////////////

#include "Globals.hpp"
#include <vector>
#include <string>
#include <SFML/Graphics.hpp>

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Bitmap Fonts
  * \author Steffen Nörtershäuser
  */
class CBitmapFont
{
public:
	//Konstruktur und Destruktor
	CBitmapFont();
	~CBitmapFont();

	void Init();

	//Zeichnet den angebenen Text
	void DrawText(float x, float y, std::string Text, float PixelHeight = 0.0f, float RectXSize = 10000.0f, float RectYSize = 10000.0f, 
				  int ScrollY = 0, bool* CanScroll = NULL, int Alpha = 255, bool CenterdX = false);

	//Diese Funktion gibt die Fonthöhe zurück
	float GetFontHeight() { return m_FontSprites[0]->GetSubRect().GetHeight(); }
private:

	//In diesem Vektor werden die BuchstabenSprites gespeichert
	std::vector<sf::Sprite*> m_FontSprites;

	//Diese Funktion fügt einen BuchstabenSprite hinzu
	void AddChar(std::string FileName);
};
#endif
