/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//BitmapFont.cpp - Definition der Klasse CBitmapFont
//CBitmapFont wird für das Darstellen BitmapFonts bentötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////

#include "Bitmapfont.hpp"
#include "Singletons.hpp"

//////////////////////////////////////////////////////////////////////////////////////////////////

CBitmapFont::CBitmapFont()
{
}

CBitmapFont::~CBitmapFont()
{
	for(std::size_t CurChar = 0; CurChar < m_FontSprites.size(); CurChar++)
	{
		delete m_FontSprites[CurChar];
	}
	m_FontSprites.clear();
}

void CBitmapFont::Init()
{
	AddChar("gfx/BitMapFont/A.png");
	AddChar("gfx/BitMapFont/B.png");
	AddChar("gfx/BitMapFont/C.png");
	AddChar("gfx/BitMapFont/D.png");
	AddChar("gfx/BitMapFont/E.png");
	AddChar("gfx/BitMapFont/F.png");
	AddChar("gfx/BitMapFont/G.png");
	AddChar("gfx/BitMapFont/H.png");
	AddChar("gfx/BitMapFont/I.png");
	AddChar("gfx/BitMapFont/J.png");
	AddChar("gfx/BitMapFont/K.png");
	AddChar("gfx/BitMapFont/L.png");
	AddChar("gfx/BitMapFont/M.png");
	AddChar("gfx/BitMapFont/N.png");
	AddChar("gfx/BitMapFont/O.png");
	AddChar("gfx/BitMapFont/P.png");
	AddChar("gfx/BitMapFont/Q.png");
	AddChar("gfx/BitMapFont/R.png");
	AddChar("gfx/BitMapFont/S.png");
	AddChar("gfx/BitMapFont/T.png");
	AddChar("gfx/BitMapFont/U.png");
	AddChar("gfx/BitMapFont/V.png");
	AddChar("gfx/BitMapFont/W.png");
	AddChar("gfx/BitMapFont/X.png");
	AddChar("gfx/BitMapFont/Y.png");
	AddChar("gfx/BitMapFont/Z.png");

	AddChar("gfx/BitMapFont/A_klein.png");
	AddChar("gfx/BitMapFont/B_klein.png");
	AddChar("gfx/BitMapFont/C_klein.png");
	AddChar("gfx/BitMapFont/D_klein.png");
	AddChar("gfx/BitMapFont/E_klein.png");
	AddChar("gfx/BitMapFont/F_klein.png");
	AddChar("gfx/BitMapFont/G_klein.png");
	AddChar("gfx/BitMapFont/H_klein.png");
	AddChar("gfx/BitMapFont/I_klein.png");
	AddChar("gfx/BitMapFont/J_klein.png");
	AddChar("gfx/BitMapFont/K_klein.png");
	AddChar("gfx/BitMapFont/L_klein.png");
	AddChar("gfx/BitMapFont/M_klein.png");
	AddChar("gfx/BitMapFont/N_klein.png");
	AddChar("gfx/BitMapFont/O_klein.png");
	AddChar("gfx/BitMapFont/P_klein.png");
	AddChar("gfx/BitMapFont/Q_klein.png");
	AddChar("gfx/BitMapFont/R_klein.png");
	AddChar("gfx/BitMapFont/S_klein.png");
	AddChar("gfx/BitMapFont/T_klein.png");
	AddChar("gfx/BitMapFont/U_klein.png");
	AddChar("gfx/BitMapFont/V_klein.png");
	AddChar("gfx/BitMapFont/W_klein.png");
	AddChar("gfx/BitMapFont/X_klein.png");
	AddChar("gfx/BitMapFont/Y_klein.png");
	AddChar("gfx/BitMapFont/Z_klein.png");

	AddChar("gfx/BitMapFont/0.png");
	AddChar("gfx/BitMapFont/1.png");
	AddChar("gfx/BitMapFont/2.png");
	AddChar("gfx/BitMapFont/3.png");
	AddChar("gfx/BitMapFont/4.png");
	AddChar("gfx/BitMapFont/5.png");
	AddChar("gfx/BitMapFont/6.png");
	AddChar("gfx/BitMapFont/7.png");
	AddChar("gfx/BitMapFont/8.png");
	AddChar("gfx/BitMapFont/9.png");

	AddChar("gfx/BitMapFont/Doppelpunkt.png");
	AddChar("gfx/BitMapFont/Punkt.png");
	AddChar("gfx/BitMapFont/AusrufeZeichen.png");
	AddChar("gfx/BitMapFont/Komma.png");
	AddChar("gfx/BitMapFont/Minus.png");
	AddChar("gfx/BitMapFont/Plus.png");
	AddChar("gfx/BitMapFont/GrößerAls.png");
	AddChar("gfx/BitMapFont/KleinerAls.png");
	AddChar("gfx/BitMapFont/Raute.png");
	AddChar("gfx/BitMapFont/Sternchen.png");
	AddChar("gfx/BitMapFont/UnterStrich.png");
	AddChar("gfx/BitMapFont/Und.png");
	AddChar("gfx/BitMapFont/KlammerAuf.png");
	AddChar("gfx/BitMapFont/KlammerZu.png");
	AddChar("gfx/BitMapFont/Slash.png");
	AddChar("gfx/BitMapFont/Gleich.png");
	AddChar("gfx/BitMapFont/FrageZeichen.png");
	AddChar("gfx/BitMapFont/Apostroph.png");
	AddChar("gfx/BitMapFont/BackSlash.png");
	AddChar("gfx/BitMapFont/Grad.png");
	AddChar("gfx/BitMapFont/Prozent.png");
	AddChar("gfx/BitMapFont/StrichPunkt.png");

	AddChar("gfx/BitMapFont/Ä.png");
	AddChar("gfx/BitMapFont/Ä_klein.png");
	AddChar("gfx/BitMapFont/Ö.png");
	AddChar("gfx/BitMapFont/Ö_klein.png");
	AddChar("gfx/BitMapFont/Ü.png");
	AddChar("gfx/BitMapFont/Ü_klein.png");

	AddChar("gfx/BitMapFont/ß.png");
}

void CBitmapFont::AddChar(std::string FileName)
{
	sf::Sprite* TempSprite = new sf::Sprite;

	TempSprite->SetImage(sgl::get_imagemgr().get_img(FileName));

	m_FontSprites.push_back(TempSprite);
}

void CBitmapFont::DrawText(float x, float y, std::string Text, float PixelHeight, float RectXSize, 
			float RectYSize, int ScrollY, bool* CanScroll, int Alpha, bool CenterdX)
{
	float Scale = PixelHeight / m_FontSprites[0]->GetSubRect().GetHeight();

	if(Scale == 0.0f)
	{
		Scale = 1.0f;
	}

	for(std::size_t CurChar = 0; CurChar < m_FontSprites.size(); CurChar++)
	{
		m_FontSprites[CurChar]->SetScale(Scale,Scale);
		m_FontSprites[CurChar]->SetColor(sf::Color(255,255,255, Alpha));
	}

	float Offset = 0.0f;
	float StandardY = y;
	y -= m_FontSprites[0]->GetSubRect().GetHeight() * Scale * ScrollY;
	int CurLine = 0;
	bool Draw = true;

	unsigned i = 0;
	int LastWhiteSpace = -1;
	int OldLastWhiteSpace = -2;
	int TextWidth = 0;
	char BreakStr[3];
	BreakStr[0] = (char)92;
	BreakStr[1] = 'n';
	BreakStr[2] = '\0';
	std::string SlashString = BreakStr;

	if(RectXSize < 10000.0f)
	{
		//Für guten Zeilenumbruch sorgen
		for(i = 0; i < Text.size(); i++)
		{
			if((int)Text[i] == 32)
			{
				LastWhiteSpace = i;
			}

			if((int)Text[i] == 92 && (Text[i + 1] == 110 || Text[i + 1] == 78))
			{
				i += 2;
				Offset = 0;
				continue;
			}

			Offset += (m_FontSprites[0]->GetSubRect().GetWidth() - 3.0f) * Scale;

			if(Offset >= RectXSize && LastWhiteSpace != -1)
			{
				if(OldLastWhiteSpace == LastWhiteSpace)
				{
					break;
				}
				Text.insert(LastWhiteSpace,SlashString);
				i = LastWhiteSpace + 1;
				OldLastWhiteSpace = LastWhiteSpace + 2;
				Offset = 0;
			}
		}	
		Offset = 0.0f;
	}

	if(CenterdX == true)
	{
		TextWidth = ((m_FontSprites[0]->GetSubRect().GetWidth() - 3.0f) * Scale) * Text.size();
		Offset = -TextWidth/2;
	}

	for(i = 0; i < Text.size(); i++)
	{
		if(i < Text.size() - 1)
		{

			if((int)Text[i] == 92 && (Text[i + 1] == 110 || Text[i + 1] == 78))
			{
				y += m_FontSprites[0]->GetSubRect().GetHeight() * Scale;

				Offset = 0;
				if(CenterdX == true)
				{
					Offset = -TextWidth/2;
				}
				i++;	//Verhindern das das n dargestellt wird
				CurLine++;
				continue;
			}
		}

		if(y - StandardY > RectYSize)
		{
			if(CanScroll != NULL)
			{
				*CanScroll = true;
			}

			break;
		}

		if(CurLine < ScrollY)
		{
			Draw = false; 
		}
		else
		{
			Draw = true;
		}

		//GroßBuchstaben
		if((int)Text[i] >= 65 && (int)Text[i] <= 90)
		{
			if(Draw == true)
			{
				m_FontSprites[(int)Text[i]-65]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[(int)Text[i]-65]));
			}
			Offset += (m_FontSprites[(int)Text[i]-65]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//KleinBuchstaben
		else if((int)Text[i] >= 97 && (int)Text[i] <= 122)
		{
			if(Draw == true)
			{
				m_FontSprites[(int)Text[i]-97+26]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[(int)Text[i]-97+26]));
			}
			Offset += (m_FontSprites[(int)Text[i]-97+26]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Zahlen
		else if((int)Text[i] >= 48 && (int)Text[i] <= 57)
		{
			if(Draw == true)
			{
				m_FontSprites[(int)Text[i]-48+52]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[(int)Text[i]-48+52]));
			}
			Offset += (m_FontSprites[(int)Text[i]-48+52]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Leerzeichen
		else if((int)Text[i] == 32)
		{
			Offset += (m_FontSprites[0]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Ausrufezeichen
		else if((int)Text[i] == 33)
		{
			if(Draw == true)
			{
				m_FontSprites[64]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[64]));
			}
			Offset += (m_FontSprites[64]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Grad
		else if((int)Text[i] == -80)
		{
			if(Draw == true)
			{
				m_FontSprites[81]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[81]));
			}
			Offset += (m_FontSprites[81]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Raute
		else if((int)Text[i] == 35)
		{
			if(Draw == true)
			{
				m_FontSprites[70]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[70]));
			}
			Offset += (m_FontSprites[70]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Und
		else if((int)Text[i] == 38)
		{
			if(Draw == true)
			{
				m_FontSprites[73]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[73]));
			}
			Offset += (m_FontSprites[73]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Klammerauf
		else if((int)Text[i] == 40)
		{
			if(Draw == true)
			{
				m_FontSprites[74]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[74]));
			}
			Offset += (m_FontSprites[74]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Klammerzu
		else if((int)Text[i] == 41)
		{
			if(Draw == true)
			{
				m_FontSprites[75]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[75]));
			}
			Offset += (m_FontSprites[75]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Sternchen
		else if((int)Text[i] == 42)
		{
			if(Draw == true)
			{
				m_FontSprites[71]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[71]));
			}
			Offset += (m_FontSprites[71]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Plus
		if((int)Text[i] == 43)
		{
			if(Draw == true)
			{
				m_FontSprites[67]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[67]));
			}
			Offset += (m_FontSprites[67]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Prozent
		if((int)Text[i] == 37)
		{
			if(Draw == true)
			{
				m_FontSprites[82]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[82]));
			}
			Offset += (m_FontSprites[82]->GetSubRect().GetWidth()-3.0f) * Scale;
		}
		
		//Komma
		else if((int)Text[i] == 44)
		{
			if(Draw == true)
			{
				m_FontSprites[65]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[65]));
			}
			Offset += (m_FontSprites[65]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Minus
		else if((int)Text[i] == 45 || (int)Text[i] == 127)
		{
			if(Draw == true)
			{
				m_FontSprites[66]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[66]));
			}
			Offset += (m_FontSprites[66]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Punkt
		else if((int)Text[i] == 46)
		{
			if(Draw == true)
			{
				m_FontSprites[63]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[63]));
			}
			Offset += (m_FontSprites[63]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Slash
		else if((int)Text[i] == 47)
		{
			if(Draw == true)
			{
				m_FontSprites[76]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[76]));
			}
			Offset += (m_FontSprites[76]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Doppelpunkt
		else if((int)Text[i] == 58)
		{
			if(Draw == true)
			{
				m_FontSprites[62]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[62]));
			}
			Offset += (m_FontSprites[62]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//KleinerAls
		else if((int)Text[i] == 60)
		{
			if(Draw == true)
			{
				m_FontSprites[69]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[69]));
			}
			Offset += (m_FontSprites[69]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Gleich
		else if((int)Text[i] == 61)
		{
			if(Draw == true)
			{
				m_FontSprites[77]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[77]));
			}
			Offset += (m_FontSprites[77]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//GrößerAls
		else if((int)Text[i] == 62)
		{
			if(Draw == true)
			{
				m_FontSprites[68]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[68]));
			}
			Offset += (m_FontSprites[68]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//FrageZeichen
		else if((int)Text[i] == 63)
		{
			if(Draw == true)
			{
				m_FontSprites[78]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[78]));
			}
			Offset += (m_FontSprites[78]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Unterstrich
		else if((int)Text[i] == 95)
		{
			if(Draw == true)
			{
				m_FontSprites[72]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[72]));
			}
			Offset += (m_FontSprites[72]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Aposthroph
		else if((int)Text[i] == 39)
		{
			if(Draw == true)
			{
				m_FontSprites[79]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[79]));
			}
			Offset += (m_FontSprites[79]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//BackSlash
		else if((int)Text[i] == 92)
		{
			if(Draw == true)
			{
				m_FontSprites[80]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[80]));
			}
			Offset += (m_FontSprites[80]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Semikolon
		else if((int)Text[i] == 59)
		{
			if(Draw == true)
			{
				m_FontSprites[83]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[83]));
			}
			Offset += (m_FontSprites[83]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Großes Ä
		else if((int)Text[i] == -60)
		{
			if(Draw == true)
			{
				m_FontSprites[84]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[84]));
			}
			Offset += (m_FontSprites[84]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//kleines ä
		else if((int)Text[i] == -28)
		{
			if(Draw == true)
			{
				m_FontSprites[85]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[85]));
			}
			Offset += (m_FontSprites[85]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Großes Ö
		else if((int)Text[i] == -42)
		{
			if(Draw == true)
			{
				m_FontSprites[86]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[86]));
			}
			Offset += (m_FontSprites[86]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//kleines ö
		else if((int)Text[i] == -10)
		{
			if(Draw == true)
			{
				m_FontSprites[87]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[87]));
			}
			Offset += (m_FontSprites[87]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//Großes Ü
		else if((int)Text[i] == -36)
		{
			if(Draw == true)
			{
				m_FontSprites[88]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[88]));
			}
			Offset += (m_FontSprites[88]->GetSubRect().GetWidth()-3.0f) * Scale;
		}

		//kleines Ü
		else if((int)Text[i] == -4)
		{
			if(Draw == true)
			{
				m_FontSprites[89]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[89]));
			}
			Offset += (m_FontSprites[89]->GetSubRect().GetWidth()-3.0f) * Scale;
		}
		//ß
		else if((int)Text[i] == -33)
		{
			if(Draw == true)
			{
				m_FontSprites[90]->SetPosition(x+Offset,y);
				sgl::get_window().Draw(*(m_FontSprites[90]));
			}
			Offset += (m_FontSprites[90]->GetSubRect().GetWidth()-3.0f) * Scale;
		}
	}
}
