/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UPDATEFRAME_HPP_INCLUDED
#define UPDATEFRAME_HPP_INCLUDED
#include <SFML/Graphics.hpp>

/// Aktuelisiert die Frames für animierte Frames
inline void update_frame(sf::Sprite& sprite, unsigned int frame_count)
{
	sf::IntRect rect(sprite.GetSubRect());
	if (rect.GetWidth() + rect.Right <= sprite.GetImage()->GetWidth())
	{
		rect.Offset(rect.GetWidth(), 0);
		sprite.SetSubRect(rect);
		return;
	}
	else if (rect.GetHeight() + rect.Bottom <= sprite.GetImage()->GetWidth())
	{
		sprite.SetSubRect(sf::IntRect(0, rect.Bottom, rect.GetWidth(), rect.Bottom + rect.GetHeight()));
		return;
	}
	else
	{
		sprite.SetSubRect(sf::IntRect(0, 0, rect.GetWidth(), rect.GetHeight()));
		return;
	}
}

#endif

