/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Star.hpp"
#include <cmath>
#include "MathFuncs.hpp"
#include "UpdateFrame.hpp"
#include "Singletons.hpp"

CStar::CStar()
		: m_SpeedX(0.0f),
		  m_SpeedY(0.0f),
		  m_Layer(0),
		  m_CanBeRemoved(false),
		  m_LastAniUpdate(0),
		  m_FieldWidth(SCREEN_X_SIZE - HUD_SIZE_X)
{}

CStar::~CStar()
{
}

void CStar::Init(const std::string& FileName, int Layer, bool Planet, int FieldWidth)
{
	m_Star.SetImage(sgl::get_imagemgr().get_img(FileName));
	framed = false;
	/// \TODO m_Star.Init(lpDevice,TexManager, Data->FileName, Data->FrameX, Data->FrameY, Data->FrameCount);

	float X = std::rand() % (FieldWidth);
	float Y = (std::rand() % (SCREEN_Y_SIZE + 100) - 100);
	
	if(Planet == true)
	{
		Y = -(std::rand() % 100 + m_Star.GetSubRect().GetHeight());
	}
		
	m_Star.SetPosition(X,Y);
	
	if(Planet == false)
	{
		m_Star.SetColor(sf::Color(Layer+128,Layer+128,Layer+128,255));
	}

	if(Planet == false)
	{
		m_Star.SetScale(0.6f,((float)Layer) / 128 + 0.5f);
	}

	m_SpeedY = 3.0f*(((float)Layer) / 128 + 100.f);
	m_Layer = Layer;
	m_IsPlanet = Planet;

	m_FieldWidth = FieldWidth;
}

void CStar::InitAsteroid(AsteroidData* Data, int Layer, float XSpeed, 
						 float YSpeed, float X, float Y)
{
	if(Data == NULL)
	{
		return;
	}
	
	m_Star.SetImage(sgl::get_imagemgr().get_img(Data->FileName));
	m_Star.SetSubRect(sf::IntRect(0, 0, Data->FrameX, Data->FrameY));
	frame_count = Data->FrameCount;
	framed = true;

	int SgnXSpeed = sgn(XSpeed);
	int SgnYSpeed = sgn(YSpeed);

	float Radius = frnd(0.0f, STAR_ASTEROID_RADIUS);
	float Angle = frnd(0, M_PI * 2);

	float XPos = std::cos(Angle) * Radius + X;
	float YPos = std::sin(Angle) * Radius + Y;

	m_Star.SetPosition(XPos,YPos);

	m_SpeedX = XSpeed;
	m_SpeedY = YSpeed;

	m_Layer = Layer;
	m_IsPlanet = true;
	m_IsAsteroid = true;
}

void CStar::Draw()
{
	static float last_frame(sgl::get_clock().GetElapsedTime());
	
	float movement = 
			(sgl::get_clock().GetElapsedTime() - static_cast<float>(last_frame))
			* 100;
	
	last_frame = sgl::get_clock().GetElapsedTime();
	
	sgl::get_window().Draw(m_Star);
	m_Star.Move(m_SpeedX*movement,m_SpeedY*movement);

	if(m_IsAsteroid == false)
	{
		if(m_Star.GetPosition().y >= SCREEN_Y_SIZE + 100)
		{
			if(m_IsPlanet == true)
			{
				m_CanBeRemoved = true;
			}

			m_Star.SetPosition(std::rand() % (m_FieldWidth),-(std::rand() % 100 - 50 - m_Star.GetSubRect().GetHeight()));
		}
	}
	else
	{
		if(m_SpeedX < 0)
		{
			if(m_Star.GetPosition().x < -m_Star.GetSubRect().GetWidth())
			{
				m_CanBeRemoved = true;
				return;
			}
		}
		else
		{
			if(m_Star.GetPosition().x > SCREEN_X_SIZE + m_Star.GetSubRect().GetWidth())
			{
				m_CanBeRemoved = true;
				return;
			}
		}

		if(m_SpeedY < 0)
		{
			if(m_Star.GetPosition().y < -m_Star.GetSubRect().GetHeight())
			{
				m_CanBeRemoved = true;
				return;
			}
		}
		else
		{
			if(m_Star.GetPosition().y > SCREEN_X_SIZE + m_Star.GetSubRect().GetHeight())
			{
				m_CanBeRemoved = true;
				return;
			}
		}
	}

	if(sgl::get_clock().GetElapsedTime()*1000 - m_LastAniUpdate > STAR_ANI_UPDATE)
	{
		m_LastAniUpdate = sgl::get_clock().GetElapsedTime()*1000;
		if (framed) update_frame(m_Star, frame_count);
	}
}
