/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Singletons.hpp"

#include <libintl.h>
#define _(string) gettext(string)

namespace
{
	struct sgls
	{
		sf::Clock clock;
		sf::RenderWindow app;
		ImageMgr imgr;
		SndBuffMgr smgr;
		sgls() : app(sf::VideoMode(1024, 768, 32), _("SFML-Space")) {}
		~sgls() {imgr.clear();}
	} sgls_;
}

namespace sgl
{
	sf::Clock& get_clock()
	{
		return sgls_.clock;
	}

	sf::RenderWindow& get_window()
	{
		return sgls_.app;
	}

	ImageMgr& get_imagemgr()
	{
		return sgls_.imgr;
	}

	SndBuffMgr& get_sndbuffmgr()
	{
		return sgls_.smgr;
	}
}

