/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Ship.h - Deklaration der Klasse CShip
//CShip Klasse die für das Verwalten der Raumschiffe benuzt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef SHIP_H
#define SHIP_H

#include "Weapon.hpp"
#include "CollisionSystem.hpp"
#include "PowerUp.hpp"
#include "Emitter.hpp"

#include <vector>
#include <string>
#include <log4cxx/logger.h>

#include <SFML/Graphics.hpp>
#include <SFML/Audio.hpp>

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Shiffe
  * \author Steffen Nörtershäuser
  */
class CShip
{
public:
	/// Konstruktor und Destruktor
	CShip();
	~CShip();

	/// Diese Funktion intialisiert das Schiff
	void Init(const std::string& FileName);

	/// Diese Funktion zeichnet das Schiff
	void Draw();

	/// Diese Funktion lässt das Schiff schießen
	void Shoot();

	/// Diese Funktion legt die Position des Schiffs fest
	void SetPosition(float X, float Y) 
	{ 
		m_Sprite.SetPosition(X,Y); 
		m_CollisionSystem.SetPosition(X + m_Sprite.GetSize().x/2,Y+m_Sprite.GetSize().y/2);
	}

	/// Diese Funktion bewegt das Schiff auf der X-Achse 
	void MoveX(int Direction);

	/// Diese Funktion bewegt das Schiff auf der Y-Achse
	void MoveY(int Direction);

	/// Diese Funktion gibt die X-Position des Schiffes zurück
	float GetXPosition() const { return m_Sprite.GetPosition().x; }

	/// Diese Funktion gibt die X-Position des Schiffes zurück
	float GetYPosition() const { return m_Sprite.GetPosition().y; }

	/// Gibt die verbleibende Rüstung / Lebenspunkte des Schiffs zurück
	const int* GetCurrentArmor() const { return &m_CurArmor; }

	/// Diese Funktion legt die Rüstung vom Schiff fest
	void SetCurArmor(int CurArmor) 
	{
		m_CurArmor = (CurArmor > m_Armor) ? CurArmor : m_Armor;
	}

	/// Gibt die maximale Rüstung / Lebenspunkte des Schiffs zurück
	int GetMaxArmor() const { return m_Armor; }

	/// Gibt die verbleibende Rüstung / Lebenspunkte des Schiffs zurück
	const int* GetMaxArmorPtr() const { return &m_Armor; }


	/// Diese Funktion rüstet die Waffe mit dem angebenen Namen aus
	/// Waffen aus der selben GruppenID mit anderem Namen werden entrüstet
	void EquipWeapon(std::string Name);

	/// Diese Funktion rüstet die Waffe mit dem angebenen Namen aus
	/// Waffen aus der selben GruppenID mit anderem Namen werden entrüstet
	void EquipWeapon(int GroupID);

	/// Diese Funktion setzt die Waffenausrüstung wieder auf den Standard wert
	void ResetWeapons();

	/// Diese Funktion überprüft ob das angeben PowerUp mit dem Schiff kollidiert
	bool CheckCollision(CPowerUp* CounterPart);

	/// Diese Funktion überprüft ob die Projektil des Schiffes mit dem angebenen Schiff  kollidieren
	/// wenn das Schiff dadurch sterben würde wird true zurück gegeben
	bool CheckCollision(CShip* CounterPart);

	/// Diese Funktion repariert das Schiff
	void Repair(int Repair);

	/// Diese Funktion beschädigt das Schiff, wird es zerstört wird true zurückgegeben
	bool Damage(int Damage);

	/// Diese Funktion gibt das KollisionSystem des Schiffes zurück
	CCollisionSystem* GetCollisionSystem() { return &m_CollisionSystem; }

	/// Diese Funktion gibt die KollisionSystem breite des Schiffes zurück
	float GetCollisionSystemWidth() { return m_CollisionSystem.GetWidth(); }

	/// Diese Funktion gibt zurück ob das Schiff zerstört ist
	bool IsDead() { return (m_CurArmor <= 0); }

	/// Diese Funktion gibt zurück ob das Schiff gelöscht werden kann
	bool CanBeRemoved() const
	{
		return (m_DeadEmiter.IsActivate() == false && m_DeadEmiter.GetParticleCount() == 0);
	}

	/// Diese Funktion gibt die Projetiklanzahl aller Waffen des Schiffes zurück
	int GetProjectilCount() const;

	/// Diese Funktion gibt X-Koordinate des angeben Projektils zurück
	float GetProjectilXPosition(int Projectil) const;

	/// Diese Funktion gibt X-Koordinate des angeben Projektils zurück
	float GetProjectilYPosition(int Projectil) const;

	/// Diese Funktion gibt Schaden der durch das angeben Projektils verursacht wird
	int GetProjectilDamage(int Projectil) const;

	/// Diese Funktion gibt Breite des angeben Projektils zurück
	float GetProjectilWidth(int Projectil) const;

	/// Diese Funktion gibt relativ zum Schiff den mittlewert der Schiffwaffentreffen zurück
	int GetProjectileTarget(int YDistance) const;

	/// Diese Funktion gibt die Anzahl der Waffen zurück
	int GetWeaponCount() const { return m_Weapons.size(); }

	/// Diese Funktion gibt den Schaden der durhc die angeben Waffe verursacht wird zurück
	int GetWeaponDamage(std::size_t Weapon) const ;

	/// Diese Funktion gibt den Name der angeben Waffe zurück
	std::string GetWeaponName(std::size_t Weapon) const;

	/// Diese Funktion gibt die Waffentypen zurück
	int GetWeaponTypeCount() const;

	/// Diese Funktion gibt die momentan ausgerüstete Waffe des angeben Waffen types zurück
	std::string GetCurWeaponNameOfType(std::size_t GroupID) const;

	/// Diese Funktion gibt die momentan ausgerüstete Waffe des angeben Waffen types zurück
	const CWeapon* GetCurWeaponOfType(std::size_t GroupID) const;


	/// Diese Funktion löscht alle Projektile des Schiffs
	void ClearProjectils()
	{
		for(std::size_t CurWeapon = 0; CurWeapon < m_Weapons.size(); CurWeapon++)
		{
			m_Weapons[CurWeapon]->ClearProjectils();
		}
	}


	/// Diese Funktion legt fest ob das Schiff unverwundbar ist
	void SetInvulnerable(bool Invulnerable) { m_Invulnerable = Invulnerable; }

	/// Diese Funktion gibt zurück ob das Schiff unverwundbar ist
	bool IsInvulnerable() const { return m_Invulnerable; }

	
	/// Diese Funktion legt den Alphawert des Schiffes fest
	void SetAlpha(float Alpha) { m_Sprite.SetColor(sf::Color(255,255,255,Alpha * 255)); }


	/// Diese Funktion legt fest wie lange zwischen den Animationsframes gewartet wird
	void SetAniDelay(int AniDelay) { m_AniDelay = AniDelay; }

	/// Diese Funktion gibt zurück wie lange zwischen den Animationsframes gewartet wird
	int GetAniDelay() const { return m_AniDelay; }


	/// Diese Funktion gibt zurück wann das Schiff zerstört wurde
	int GetDeadTime() const { return m_DeadTime; }
private:
	//Diese Funktion gibt alles frei
	void CleanUp();

	//Diese Funktion liest die WaffenDaten aus der angeben Datei aus
	void ReadWeapon(FILE* ShipFile, CWeapon* Weapon);

	sf::Sprite m_Sprite;	//Das Sprite das das Schiff darstellt
	int m_CurArmor;		//Die momentane Rüstung des Schiffes, d.h. wieviel es noch aushält
	int m_Armor;		//Die Maximal Rüstung des Schiffes
	float m_Speed;		//Die Geschwindigkeit des Schiffes

	int m_LastAniUpdate; //Wann die Animation das letze mal aktualisiert wurde
	int m_AniDelay;		 //Wie lange zwischen 

	std::string m_DeadSoundFile;		//Der DateiName des SterbeSounds des Schiffes

	//Dieser Sound wird abgespielt wenn das Schiff zerstört wird
	sf::Sound m_DeadSound;

	float m_EngineX;			//Die X-Position des Antriebs
	float m_EngineY;			//Die Y-Position des Antriebs
	CEmiter m_EngineEmiter;		//Der AntriebsEmiter

	CEmiter m_DeadEmiter;		//Der Emiter der bei der Zerstörung des Schiffs abgespielt wird
	int m_DeadEmiterTime;		//Wie lange der Emiter nach der Zerstörung des Schiffes aktiv bleiben soll
	int m_DeadTime;				//Wann das Schiff zerstört wurde in Millisekunden*/

	std::vector<CWeapon*> m_Weapons;	//Die Waffen des Schiffes

	bool m_Invulnerable;		//Ob das Schiff gerade unterverwundbar ist

	CCollisionSystem m_CollisionSystem;	//Das Kollisisions System

	log4cxx::LoggerPtr log_;
	unsigned int frame_count;
};

#endif
