/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//SaveManager.h - Deklaration der Klasse CSaveManager
//CSaveManager wird für das verwalten von Speicherständen benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef SAVEMANAGER_H
#define SAVEMANAGER_H

#include "Globals.hpp"
#include "Globals.hpp"
#include "Bitmapfont.hpp"
#include "MenuListField.hpp"
#include <string>
#include <vector>


//////////////////////////////////////////////////////////////////////////////////////////////////

struct SaveData
{
	std::string SaveFile;
	std::string ListName;
	std::string KampagneName;
	int Mission;
	int Lives;
};

/** \brief Verwaltung gespeicherter Spielstände
  * \author Steffen Nörtershäuser
  */
class CSaveManager
{
public:
	//Konstruktor und Destrukor
	CSaveManager();
	~CSaveManager();

	//Diese Funktion speichert einen Save
	void Save(std::string Folder, std::string Campaign, int Mission, int Lives);

	//Diese Funktion speichert einen Save
	void SaveFile(std::string File, std::string Campaign, int Mission, int Lives);


	//Diese Funktion liest alle Speicherstände aus dem angebenen Ordner aus
	void ReadSavesFromFolder(std::string Folder);

	//Diese Funktion gibt die Anzahl der Speicherstände zurück
	std::size_t GetSaveCount() const { return m_SaveData.size(); }

	//Diese Funktion gibt die SaveDaten zurück
	SaveData* GetSaveData(std::size_t Index) 
	{
		if(Index >= m_SaveData.size())
		{
			return NULL;
		}

		return m_SaveData[Index];
	}

	//Diese Funktion liest einen Save aus
	SaveData* ReadSave(std::string FileName);
private:
	void CleanUp();		//Alles aufräumen

	std::vector<SaveData*> m_SaveData;	//Die Speicherstand Daten die ausgelesen wurden
};

#endif

