/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "SaveManager.hpp"

#include <cstdio>
#include <cstring>
#include <boost/filesystem.hpp>

CSaveManager::CSaveManager()
{}

CSaveManager::~CSaveManager()
{
	CleanUp();
}

void CSaveManager::CleanUp()
{
	for(std::size_t CurSave = 0; CurSave < m_SaveData.size(); CurSave++)
	{
		delete m_SaveData[CurSave];
	}
	m_SaveData.clear();
}

void CSaveManager::SaveFile(std::string File, std::string Campaign, int Mission, int Lives)
{
	FILE* Save = std::fopen(File.c_str(),"wb");
	if(Save == NULL)
	{
		return;
	}

	char Zero = '\0';

	std::fwrite(Campaign.c_str(),Campaign.length(),1,Save);
	std::fwrite(&Zero,sizeof(char),1,Save);
	std::fwrite(&Mission,sizeof(int),1,Save);
	std::fwrite(&Lives,sizeof(int),1,Save);

	std::fclose(Save);
}

void CSaveManager::Save(std::string Folder, std::string Campaign, int Mission, int Lives)
{
	ReadSavesFromFolder(Folder);

	char FileName[100];
	std::sprintf(FileName,"/%d.sav",m_SaveData.size());

	m_SaveData.clear();

	std::string TempFile = Folder + FileName;

	SaveFile(TempFile, Campaign, Mission, Lives);
}

void CSaveManager::ReadSavesFromFolder(std::string Folder)
{
	CleanUp();

	boost::filesystem::directory_iterator end;
	
	const long MaxLength = 200;
	std::string SaveName;

	char Direction[MaxLength*3];
	char DataFile[MaxLength*3];
	std::memset(Direction,'\0',MaxLength*3);
	std::memset(DataFile,'\0',MaxLength*3);

	std::string TempFolder = Folder + "/*.sav"; 
	std::strcpy(Direction,TempFolder.c_str());

	for ( boost::filesystem::directory_iterator it = 
				boost::filesystem::directory_iterator(boost::filesystem::path(Folder) );
			it != end; it++)
	{
		if (it->path().string().find(".sav") == std::string::npos)
			continue;

		ReadSave(it->path().string());
	}
}

SaveData* CSaveManager::ReadSave(std::string FileName)
{
	FILE* Save = std::fopen(FileName.c_str(),"rb");

	if(Save == NULL)
	{
		return NULL;
	}

	std::string Name = "";
	char FileChar;

	while(1)
	{
		std::fread(&FileChar,1,1,Save);

		if((int)FileChar == 0)
		{
			break;
		}

		Name += FileChar;
	}

	int Mission;
	std::fread(&Mission,sizeof(int),1,Save);
	int Lives;
	std::fread(&Lives,sizeof(int),1,Save);

	std::fclose(Save);

	std::string ListName = "";
	std::size_t ListPos = Name.find("/",0);
	if(ListPos != std::string::npos)
	{
		ListName = Name.substr(ListPos + 1);
		ListName.erase(ListName.length() - 4,4);

		ListName += ", Mission: ";
	
		char strBuf[10];
		std::sprintf(strBuf,"%d",Mission + 1);
		ListName += strBuf;
	}

	SaveData* Data = new SaveData;
	Data->SaveFile = FileName;
	Data->KampagneName = Name;
	Data->Mission = Mission;
	Data->ListName = ListName;
	Data->Lives = Lives;

	m_SaveData.push_back(Data);

	return Data;
}
