/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <string>
#include <vector>

#include <log4cxx/logger.h>

/** \brief Playlist für Hintergrundmusik
  * \author Christoph Egger
  */
class CPlaylist
{
public:
	CPlaylist() : p_HUD(0), log_(log4cxx::Logger::getLogger("CPlaylist")) {}
	~CPlaylist(){}
	int init(std::string filename);
	void HUDout(std::string* ausgabe) {p_HUD = ausgabe;}
	std::string getRandSong();
private:
	std::string* p_HUD;
	struct SSongInfo
	{
		std::string filename;
		std::string title;
		unsigned int length;
	};
	std::vector<SSongInfo> m_Songs;
	int m_actualSong;
	log4cxx::LoggerPtr log_;
};


#endif

