/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Playlist.hpp"
#include "Globals.hpp"

#include <cstdlib>
#include <cstdio>
#include <libintl.h>
#define _(string) gettext(string)

int CPlaylist::init(std::string filename)
{
	bool extended;
	m_Songs.clear();
	char buffer[255];
	std::string Buffer;
	int count = 0;
	CPlaylist::SSongInfo tmp;
	FILE* the_file = fopen(filename.c_str(), "r");
	if(the_file == NULL)
	{
		return 0;
	}
	fgets(buffer,255,the_file);
	Buffer = buffer;
	if (Buffer == "#EXTM3U\n")
	{
		while(fgets(buffer, 255, the_file) != 0)
		{
			Buffer = buffer;
			std::string test(Buffer, 0, 8);
			if (test != "#EXTINF:")
			{
				LOG4CXX_ERROR(log_, test.c_str());
				LOG4CXX_ERROR(log_, _("Error while reading the Playlist!"));
				return 0;
			}
			sscanf(Buffer.c_str(), "#EXTINF:%d", &(tmp.length));
			int i = Buffer.find(",");
			std::string info(Buffer, i + 1, (Buffer.size() - (i+2)));
			if (fgets(buffer, 255, the_file) == NULL)
			{
				LOG4CXX_ERROR(log_, _("Error while reading the Playlist!"));
				return 0;
			}
			Buffer = buffer;
			std::string sfilename(Buffer, 0, (Buffer[Buffer.size()-1]== '\n') ? Buffer.size() - 1 : Buffer.size());
			tmp.filename = sfilename;
			tmp.title = info;
			m_Songs.push_back(tmp);
			++count;
		}
	}
	else
	{
		tmp.filename = Buffer;
		std::string info(Buffer, 0, Buffer.size() - 4);
		tmp.title = info;
		tmp.length = 0;
		m_Songs.push_back(tmp);
		while (fgets(buffer, 255, the_file) != 0)
		{
			Buffer = buffer;
			tmp.filename = Buffer;
			std::string info(Buffer, 0, Buffer.size() - 4);
			tmp.title = info;
			tmp.length = 0;
			m_Songs.push_back(tmp);
			++count;
		}
	}
	++count;
	
	std::fclose(the_file);
	return count;
}

std::string CPlaylist::getRandSong()
{
	unsigned count = m_Songs.size();
	if (count == 0) return "";
	m_actualSong = std::rand()%count;

	if(p_HUD)
	{
		char tmp[255];
		if (m_Songs[m_actualSong].length)
		{
			sprintf(tmp, "%s (%d:%d)", m_Songs[m_actualSong].title.c_str(), m_Songs[m_actualSong].length/60, m_Songs[m_actualSong].length%60);
		}
		else 
		{
			sprintf(tmp, "%s (unbekannt)", m_Songs[m_actualSong].title.c_str());
		}
		*p_HUD = tmp;
	}
	
	return m_Songs[m_actualSong].filename;
}
