/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Player.h - Deklaration der Klasse CPlayer
//CPlayer Klasse die für das Verwalten der Spieler benutzt wird
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef PLAYER_H
#define PLAYER_H

#include "Ship.hpp"

#include <string>


static const unsigned int PLAYER_INITIAL_LIVES = 3;

static const unsigned int PLAYER_RESPAWN_TIME = 2000;

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Spielerklasse
  * \author Steffen Nörtershäuser
  */
class CPlayer
{
public:
	/// Konstruktor und Destruktor
	CPlayer();
	~CPlayer();

	/// Diese Funktion intialisiert den Spieler
	void Init(const std::string& FileName);

	/// Diese Funktion zeichnet das Schiff des Spielers
	void Draw() { m_Ship->Draw(); }

	/// Diese Funktion akualisiert den Spieler
	void Update();

	/// Diese Funktion gibt die X-Position des Spielers zurück
	float GetXPosition() const { return m_Ship->GetXPosition(); }

	/// Diese Funktion gibt die Y-Position des Spielers zurück
	float GetYPosition() const { return m_Ship->GetYPosition(); }

	/// Diese Funktion gibt das Shiff zurück
	CShip* GetShip() { return m_Ship; }

	const CShip* GetShip() const {return m_Ship;}

	/// Diese Funktion rüstet die angeben Waffe aus
	void EquipWeapon(std::string Name) { m_Ship->EquipWeapon(Name); }

	/// Diese Funktion setzt die Ausrüstung zurück
	void ResetWeapons() { m_Ship->ResetWeapons(); }

	/// Diese Funktion überprüft ob das angeben PowerUp mit dem Spieler kollidiert
	bool CheckCollision(CPowerUp* CounterPart) { return m_Ship->CheckCollision(CounterPart); }

	/// Diese Funktion überprüft ob die Projektil des Spieler-Schiffes mit dem angebenen Schiff  kollidieren
	/// wenn das Schiff dadurch sterben würde wird true zurück gegeben
	bool CheckCollision(CShip* CounterPart) { return m_Ship->CheckCollision(CounterPart); }

	/// Diese Funktion gibt zurück ob der Spieler tot ist
	bool IsDead() const { return m_Ship->IsDead(); }

	/// Diese Funktion gibt die ProjektilAnzahl des SpielerSchiffes zurück
	std::size_t GetProjectilCount() const { return m_Ship->GetProjectilCount(); }

	/// Diese Funktion gibt die X-Koordinate des Angebenen Projektil des SpielerSchiffes zurück
	float GetProjectilX(int Projectil) const { return m_Ship->GetProjectilXPosition(Projectil); }

	/// Diese Funktion gibt die X-Koordinate des Angebenen Projektil des SpielerSchiffes zurück
	float GetProjectilY(int Projectil) const { return m_Ship->GetProjectilYPosition(Projectil); }

	/// Diese Funktion gibt die X-Koordinate des Angebenen Projektil des SpielerSchiffes zurück
	float GetProjectilDamage(int Projectil) const { return m_Ship->GetProjectilDamage(Projectil); }
	
	/// Diese Funktion gibt die X-Koordinate des Angebenen Projektil des SpielerSchiffes zurück
	float GetProjectilWidth(int Projectil) const { return m_Ship->GetProjectilWidth(Projectil); }


	/// Diese Funktion gibt WaffenAnzahl des Spielerschiffs zurück
	std::size_t GetWeaponCount() const { return m_Ship->GetWeaponCount(); }

	/// Diese Funktion gibt den WaffenSchaden der angeben Waffe zurück
	int GetWeaponDamage(int Weapon) const { return m_Ship->GetWeaponDamage(Weapon); }

	/// Diese Funktion gibt die bretie des KollisionSystems des SpielerSchiffes zurück
	float GetCollisionSystemWidth() const { return m_Ship->GetCollisionSystemWidth(); }


	/// Diese Funktion gibt die Waffentypen zurück
	std::size_t GetWeaponTypeCount() const { return m_Ship->GetWeaponTypeCount(); }

	/// Diese Funktion gibt die momentan ausgerüstete Waffe des angeben Waffen types zurück
	std::string GetCurWeaponNameOfType(std::size_t GroupID) { return m_Ship->GetCurWeaponNameOfType(GroupID); }

	/// Diese Funktion gibt die momentan ausgerüstete Waffe des angeben Waffen types zurück
	const CWeapon* GetCurWeaponOfType(std::size_t GroupID) { return m_Ship->GetCurWeaponOfType(GroupID); }


	/// Diese Funktion gibt zurück ob der Spieler entfernt werden kann ist
	bool CanBeRemoved();


	/// Diese Funktion gibt Leben des Spielers als String zurück
	const std::string* GetLiveString() const { return &m_LiveString; }

	/// Diese Funktion gibt die Anzahl der Leben zurück
	int GetLives() const { return m_Lives; }

	/// Diese Funktion legt die Anzahl der Leben fest
	void SetLives(int Lives)
	{ 
		m_Lives = Lives; 

		char strBuf[50];
		sprintf(strBuf,"Leben: %d",m_Lives);
		m_LiveString = strBuf;
	}

private:
	CShip* m_Ship;	//Das Schiff des Spielers

	int m_Lives;		 //Die Leben des Spielers
	std::string m_LiveString; //Die Leben als String gespeichert für das HUD

	bool m_Respawning;	 //Ob der Spieler gerade wiederbelebt wird
	int m_LastDeadTime;	 //Wann der spieler das letzte mal gestorben
};

#endif
