/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Particle.h - Deklaration der Klasse CParticle
//CParticle wird fï¿½r das verwalten von Partikeln benï¿½tigt
//Steffen Nï¿½rtershï¿½user
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef PARTICLE_H
#define PARTICLE_H

#include "Globals.hpp"

#include <SFML/Graphics.hpp>
#include <string>

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Partikel
  * \author Steffen Nörtershäuser
  */
class CParticle
{
public:
	/// Konstruktor und Destruktor
	CParticle();
	~CParticle();

	/// Diese Funktion intialisiert den Partikel
	void Init(const std::string& TexName, float FrameWidth = -1, float FrameHeight = -1, int FrameCount = 1);

	/// Diese Funktion legt die Position des Partikels fest
	void SetPosition(float X, float Y) { m_Sprite.SetPosition(X,Y); }

	/// Diese Funktion gibt true zurï¿½ck wenn der Partikel gelï¿½scht werden sollte
	bool Remove();

	/// Diese Funktion aktualisiert den Partikel
	void Update();

	/// Diese Funktion zeichnet die Partikel
	void Draw();

	/// Diese Funktion legt die Lebensspanne des Partikels fest
	void SetLifeSpan(int LifeSpan) { m_LifeTime = LifeSpan; }

	/// Diese Funktion legt die Skalirung des Partikels fest
	void SetScale(float X, float Y) 
	{ 
		m_Sprite.SetScale(X,Y); 
		m_StartScaleX = X;
		m_StartScaleY = Y;
	}

	/// Diese Funktion legt die EndSkalirung des Partikels fest
	void SetTargetScale(float X, float Y)
	{
		m_EndScaleX = X;
		m_EndScaleY = Y;
	}

	/// Diese Funktion legt den Startalpha wert des Partikels fest
	void SetStartAlpha(int Alpha) { m_StartAlpha = Alpha; }

	/// Diese Funktion legt den Endalpha wert des Partikels fest
	void SetEndAlpha(int Alpha) { m_EndAlpha = Alpha; }


	/// Diese Funktion legt den StartRotWert des Partikels fest
	void SetStartRed(int Red) { m_StartRed = Red; }

	/// Diese Funktion legt den EndRotWert des Partikels fest
	void SetEndRed(int Red) { m_EndRed = Red; }

	/// Diese Funktion legt den StartGrï¿½nWert des Partikels fest
	void SetStartGreen(int Green) { m_StartGreen = Green; }

	/// Diese Funktion legt den EndGrï¿½nWert des Partikels fest
	void SetEndGreen(int Green) { m_EndGreen = Green; }

	/// Diese Funktion legt den StartBlauWert des Partikels fest
	void SetStartBlue(int Blue) { m_StartBlue = Blue; }

	/// Diese Funktion legt den EndBlauWert des Partikels fest
	void SetEndBlue(int Blue) { m_EndBlue = Blue; }


	/// Diese Funktion legt die Startgeschwindigkeit des Partikels fest
	void SetStartVelX(float StartVelX) { m_StartVelX = StartVelX; }

	/// Diese Funktion legt die Endgeschwindigkeit des Partikels fest
	void SetEndVelX(float EndVelX) { m_EndVelX = EndVelX; }


	/// Diese Funktion legt die Startgeschwindigkeit des Partikels fest
	void SetStartVelY(float StartVelY) { m_StartVelY = StartVelY; }

	/// Diese Funktion legt die Endgeschwindigkeit des Partikels fest
	void SetEndVelY(float EndVelY) { m_EndVelY = EndVelY; }


	/// Diese Funktion legt die Zeit in Millisekunden zwischen dem inkrementieren des Frames gewartet wird fest
	void SetAniSpeed(int AniSpeed) { m_AniSpeed = AniSpeed; }
private:
	sf::Sprite m_Sprite;	//Das Sprite des Partikels
	
	int m_LastAniUpdate;	//Wann der Frame des Sprites das letze mal inkrementiert wurde
	int m_AniSpeed;			//Wieviele Millisekunden zwischen dem inkrementieren des Frames gewartet wird

	int m_SpawnTime;	//Die Millisekunden als der Partikel erstellt wurde
	int m_LifeTime;		//Wieviele Millisekunden der Partikel leben soll

	float m_StartScaleX;	//Die Startskalirung auf der X-Achse des Partikels
	float m_StartScaleY;	//Die Startskalirung auf der Y-Achse des Partikels

	float m_EndScaleX;	//Die Endskalirung auf der X-Achse des Partikels
	float m_EndScaleY;	//Die Endskalirung auf der Y-Achse des Partikels

	int m_StartAlpha;	//Der StartAlpha wert
	int m_EndAlpha;		//Der EndAlpha wert

	int m_StartRed;		//Der StartRot Wert des Partikels
	int m_EndRed;		//Der EndRot Wert des Partikels

	int m_StartGreen;	//Der StartGrï¿½n Wert des Partikels
	int m_EndGreen;		//Der EndGrï¿½n Wert des Partikels

	int m_StartBlue;	//Der StartBlau Wert des Partikels
	int m_EndBlue;		//Der EndBlau Wert des Partikels

	float m_StartVelX;	//Die Startgeschwindigkeit des Partikels auf der X-Achse
	float m_EndVelX;	//Die Endgeschwindigkeit des Partikels auf der X-Achse

	float m_StartVelY;	//Die Startgeschwindigkeit des Partikels auf der Y-Achse
	float m_EndVelY;	//Die Endgeschwindigkeit des Partikels auf der Y-Achse

};

#endif
