/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef NPC_H
#define NPC_H

#include <bitset>
#include <iostream>

#include "Ship.hpp"
#include "Enemy_Help.hpp"
#include "Globals.hpp"

/** \brief Basisklasse für NPCs
  * \author Christoph Egger
  */
class ANPC
{
public:
	enum Strength 
	{
		EMPTY, 
		WEAK_ENEMY, 
		MEDIUMWEAK_ENEMY, 
		AVERAGE_ENEMY, 
		MEDIUMHARD_ENEMY, 
		HARD_ENEMY, 
		WEAK_BOSS = 101, 
		MEDIUMWEAK_BOSS = 102, 
		AVERAGE_BOSS = 103, 
		MEDIUMHARD_BOSS = 104, 
		HARD_BOSS = 105
	};
protected:
	int des_x, des_y;
	AI_parameter* m_parameter;
	int desired_distance;
	int desired_center;
	CShip* m_Ship;
	int m_weapon_offset;
private:
	unsigned int m_starttime;
	int rest_x, rest_y;
	Strength m_strength;
	int m_firedist;
	std::string m_shipfile;
	int m_posx, m_posy;
protected:
	float get_fancy(float* farray, std::size_t start, std::size_t end);
private:
	//////////
	//Virtuelle Funktionen
	//////////
	/*
	*result muss ein int [3] sein, Inhalt ist am Schluss die Zahl der jeweiligen Gegner in die Richtung
	*[0] für links [1] für mitte [2] für rechts
	*/
	virtual void number_enemys(int* results, std::list<ANPC*>& r_Enemys) =0;
	
	/*Berechnet, in welche Y-Richtung sich der NPC optimalerweise bewegt*/
	virtual bool calculate_y(float* down_up) =0;

	//////////
	//Implementierte Funktionen
	//////////
	/*Bewegt das Schiff in y-Richtung, überprüft dabei ob die Wartezeit abgelaufen ist*/
	void steer_y(int direction);
	/*Bewegt das Schiff in x-Richtung, überprüft dabei ob die Wartezeit abgelaufen ist*/
	void steer_x(int direction);
	/*Berechnung der "beliebtheit" jedes Pixels für den NPC*/
	void update_array(float* fancy,  std::list<projectileData>& r_Projectiles);
	/*Diese Funktion sorgt dafür, dass die NPC einen minimalabstand halten*/
	void separation(std::list<ANPC*>& r_activeEnemys, float* xseparate, float* yseparate);
	/*Berechnet, in welche X-Richtung sich der NPC optimalerweise bewegt*/
	bool calculate_x(float* fancy, float* fancy_dir,  std::list<projectileData>& r_Projectiles, std::list<ANPC*>& r_activeEnemys);	
public:
	//Konstruktor/Destruktor usw.
	ANPC(unsigned int starttime, int posx, int posy, Strength theStrength, std::string shipfile, AI_parameter* parameter);
	~ANPC() 
		{if (m_Ship) delete m_Ship;}
	bool init(global_data_pointers Data, strength* tStrength);

	//Berechnungsfunktionen
	/*Berechnung der Bewegungsrichtung des NPC, wird seltener aufgerufen als update()*/
	void calculate(float* fancy, std::list<projectileData>& r_Projectiles, std::list<ANPC*>& r_myEnemys, std::list<ANPC*>& r_myAllys);
	/*Führt jeden Frame die in calculate berechnete Bewegung durch, schießt bei Bedarf*/
	void update(const std::bitset<SCREEN_X_SIZE - HUD_SIZE_X>& owned);
	void Draw()
		{m_Ship->Draw();}

	//Elementzugriff
	CShip* getShip()
		{return m_Ship;}
	unsigned int getStarttime() 
		{return m_starttime;}
	int getPower()
		{return (m_strength > 100) ? m_parameter->max_power : 1;}
	int getStrength()
		{return m_strength;}
};



#endif
