/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "NPC.hpp"
#include "Enemy.hpp"
#include "MathFuncs.hpp"

#include <cmath>

bool ANPC::init(global_data_pointers Data, strength* tStrength)
{
	m_Ship->Init(m_shipfile);
	m_Ship->SetPosition(m_posx, m_posy);
	

	desired_distance = m_parameter->des_dist_base + frnd(-m_parameter->des_dist_var, m_parameter->des_dist_var);
	desired_center = SCREEN_X_SIZE/2 + frnd(-m_parameter->des_x_var, m_parameter->des_x_var);

	m_firedist = tStrength->firedist;

	if (tStrength->boni.size() > 0)
	{
		std::list<bonus*>::iterator IT = tStrength->boni.begin();
		while (IT != tStrength->boni.end())
		{
			for (int i = 0; i < (*IT)->number; i++) 
				m_Ship->EquipWeapon((*IT)->id);
			++IT;
		}
	}

	return true;
}

ANPC::ANPC(unsigned int starttime, int posx, int posy, Strength theStrength, std::string shipfile, AI_parameter* parameter)
		: m_Ship(new CShip()),
		  m_shipfile(shipfile),
		  m_posx(posx),
		  m_posy(posy),
		  m_strength(theStrength),
		  m_starttime(starttime),
		  m_parameter(parameter),
		  des_x(0),
		  des_y(0)
{}

void ANPC::update(const std::bitset<SCREEN_X_SIZE - HUD_SIZE_X>& owned)
{
	static float last_frame(sgl::get_clock().GetElapsedTime());
	
	float movement = 
			(sgl::get_clock().GetElapsedTime() - static_cast<float>(last_frame))
			* 100;
	
	last_frame = sgl::get_clock().GetElapsedTime();
	
	m_Ship->MoveX(des_x * movement);
	m_Ship->MoveY(des_y * movement);

	int start, ende;
	
	start = ((m_Ship->GetXPosition() - m_firedist) + m_weapon_offset > 0) 
				? ((m_Ship->GetXPosition() - m_firedist) + m_weapon_offset) 
				: 0;

	ende = (m_Ship->GetXPosition() + m_firedist + m_weapon_offset <= SCREEN_X_SIZE - HUD_SIZE_X) 
				? (m_Ship->GetXPosition() + m_firedist + m_weapon_offset) 
				: (SCREEN_X_SIZE - HUD_SIZE_X);

	for(; start < ende; start++)
	{
		if (owned.test(start))
		{
			m_Ship->Shoot();
			break;
		}	
	}
}

void ANPC::calculate(float* fancy, std::list<projectileData>& r_Projectiles, std::list<ANPC*>& r_myEnemys, std::list<ANPC*>& r_myAllys)
{
	rest_x++;
	rest_y++;

	float xseparate[2];
	float yseparate[2];
	
	m_weapon_offset = m_Ship->GetProjectileTarget(SCREEN_Y_SIZE/4);

	xseparate[0] = 0;
	yseparate[0] = 0;
	xseparate[1] = 0;
	yseparate[1] = 0;

	float fancydir[3];

	fancydir[0] = 0;
	fancydir[1] = 0;
	fancydir[2] = 0;

	//calculate_x / - y gibt false zurück, falls die berechnung einen grund entdeckt hat die Richtung direckt zu ändern
	bool skip_Y = !calculate_y(yseparate);
	bool skip_X = !calculate_x(fancy, fancydir, r_Projectiles, r_myEnemys);

	//falls beide Richtungen nicht berechnet werden sollen kann die übrige Berechnung gespaart werden
	if (skip_X && skip_Y)
		return;
	
	separation(r_myAllys, xseparate, yseparate);

	if (!skip_X)
	{
		fancydir[0] += xseparate[0];
		fancydir[2] += xseparate[1];

		if ((fancydir[2] > fancydir[1] + 5) && (fancydir[2] > fancydir[0]))
		{
			steer_x(1);
		}
		else if (fancydir[0] > fancydir[1] + 5)
		{
			steer_x(-1);
		}
		else
		{
			steer_x(0);
		}
	}

	if(!skip_Y)
	{
		if (yseparate[0] > 0 && yseparate[0] > yseparate[1])
		{
			steer_y(1);
		}
		else if (yseparate[1] > 0)
		{
			steer_y(-1);
		}
		else
		{
			steer_y(0);
		}
	}
}

void ANPC::separation(std::list<ANPC*>& r_activeEnemys, float* xseparate, float* yseparate)
{
	float tmp;
	float des_man = m_parameter->des_man / std::sqrt(r_activeEnemys.size());

	std::list<ANPC*>::iterator it = r_activeEnemys.begin();

	while (it != r_activeEnemys.end())
	{
		if (*it != this && (tmp = des_man - manhattan(m_Ship->GetXPosition(), m_Ship->GetYPosition(), (*it)->getShip()->GetXPosition(), (*it)->getShip()->GetYPosition()) > 0))
		{
			int i;
			i = sgn(m_Ship->GetXPosition() - (*it)->getShip()->GetXPosition());
			xseparate[1] += i * tmp * m_parameter->sep_x_mult;
			xseparate[0] += i * tmp * m_parameter->sep_x_mult;
			i = sgn(m_Ship->GetYPosition() - (*it)->getShip()->GetYPosition());
			yseparate[1] += (i * tmp/des_man) * m_parameter->sep_y_mult;
			yseparate[0] += (i * tmp/des_man) * m_parameter->sep_y_mult;
		}
		it++;
	}
}

bool ANPC::calculate_x(float* fancy, float* fancy_dir,  std::list<projectileData>& r_Projectiles, std::list<ANPC*>& r_activeEnemys)
{
	
	int left_border = m_Ship->GetXPosition() - m_Ship->GetCollisionSystemWidth()/2;
	int right_border = m_Ship->GetXPosition() + m_Ship->GetCollisionSystemWidth()/2;

	if (left_border + static_cast<int>(m_Ship->GetCollisionSystemWidth()/3) < 0) 
	{
		des_x = 1;
		return false;
	}
	if (right_border - static_cast<int>(m_Ship->GetCollisionSystemWidth()/3) 
			> static_cast<int>(SCREEN_X_SIZE - HUD_SIZE_X)) 
	{
		des_x = -1;
		return false;
	}

	update_array(fancy, r_Projectiles);

	int numbers[3];

	numbers[0] = 0;
	numbers[1] = 0;
	numbers[2] = 0;

	number_enemys(numbers, r_activeEnemys);

	//printf("%d:%d:%d\n", numbers[0], numbers[1], numbers[2]);

	if (numbers[0] > numbers[1] && numbers[0] > numbers[2])
		fancy_dir[0] += m_parameter->player_weight;
	else if (numbers[2] > numbers[1])
		fancy_dir[2] += m_parameter->player_weight;
	else
		fancy_dir[1] += m_parameter->player_weight;


	fancy_dir[1] += get_fancy(fancy, left_border, right_border);

	fancy_dir[0] += get_fancy(fancy, left_border - m_parameter->searchdepth, right_border - m_parameter->searchdepth);

	fancy_dir[2] += get_fancy(fancy, left_border + m_parameter->searchdepth, right_border + m_parameter->searchdepth);

	return true;
}


void ANPC::update_array(float* fancy,  std::list<projectileData>& r_Projectiles)
{
	const int randbreite = (m_Ship->GetCollisionSystemWidth()/4)*4;
	static const int width = SCREEN_X_SIZE - HUD_SIZE_X;

	std::list<projectileData>::iterator tmp = r_Projectiles.begin();
	float ftmp;
	int i;

	for (i = 0; i < width; i++)
	{
		fancy[i] = 0;//-(abs(j - desired_center) * m_parameter->des_x_heavy); 
	}

	//Die Gefahr durch Projektile wird für jeden x-Wert anhand von
	//Schaden und Y-Entfernung der Projektile bestimmt
	while (tmp != r_Projectiles.end())
	{
		
		if (tmp->posy > (m_Ship->GetYPosition() - m_Ship->GetCollisionSystemWidth()/2))
		{
			ftmp = ((tmp->posy - m_Ship->GetYPosition()) < 400) ? (1 / ((tmp->posy - m_Ship->GetYPosition())/m_parameter->dist_divisor) * tmp->damage) : 0;	
			for (i = (tmp->posx - tmp->width/2) ; i < (tmp->posx + tmp->width/2); i++)
			{
				if (i >= 0 && i < width)
				{
					
					if (fancy[i] >= -ftmp)
						fancy[i] = -ftmp;
				}
			}
		}
		tmp++;
	}
	//Weiterleitung der Ergebnisse Richtung Rand
	ftmp = 0;
	for (i = randbreite; i >= 0; i--)
	{
		ftmp = fancy[i] += ftmp;
	}
	ftmp = 0;
	for (i = (width - randbreite); i < width; i++)
	{
		ftmp = fancy[i] += ftmp;	
	}
}

void ANPC::steer_x(int direction)
{
	if(direction == des_x) return;
	if(direction == 0)
	{
		des_x = 0;
		return;
	}
	if (des_x == 0)
	{
		if (rest_x >= m_parameter->pause)
		{
			des_x = direction;
		}
	}
	else
	{
		des_x = 0;
	}
}

void ANPC::steer_y(int direction)
{
	if(direction == des_y) return;
	if(direction == 0)
	{
		des_y = 0;
		return;
	}
	if (des_y == 0)
	{
		if (rest_y >= m_parameter->pause)
		{
			des_y = direction;
		}
	}
	else 
	{
		des_y = 0;
	}
}

float ANPC::get_fancy(float* fancy, std::size_t start, std::size_t end)
{
	/// \todo Das hier ist FALSCH! Signed ist nötig
	float result = 0;

	for (std::size_t i = start; i < end; i++)
	{
		if (i < 0)
		{
			result += fancy[0];
		}
		else if (i >= SCREEN_X_SIZE - HUD_SIZE_X)
		{
			result += fancy[(SCREEN_X_SIZE - HUD_SIZE_X) - 1];
		}
		else
		{
			result += fancy[i];
		}
	}
	return result;
}
