/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MISSION_H
#define MISSION_H

#include <string>
#include "Playlist.hpp"

/** \brief Einzelne Missionen
  * \author Christoph Egger
  */
class CMission
{
private:
	std::string m_ai_wave;
	std::string m_ai_params;
	std::string m_Beschreibung;
	std::string m_title;
	std::string m_PShip;
	//CPlaylist m_playlists[2];
	std::string m_playlist[2];
	std::string m_image;
	int m_framecount;
	int m_framedelay;
public:
	CMission(std::string ai_wave, std::string ai_params, std::string Beschreibung, std::string Title, 
		std::string PShip, std::string playlist[2], std::string image ="", int framecount = 1, int framedelay = 10):
			m_ai_wave(ai_wave), 
			m_ai_params(ai_params),
			m_Beschreibung(Beschreibung),
			m_title(Title),
			m_PShip(PShip),
			m_image(image),
			m_framecount(framecount),
			m_framedelay(framedelay)
			{m_playlist[0] = playlist[0];m_playlist[1] = playlist[1];}
	std::string get_ai_wave()
		{return m_ai_wave;}
	std::string get_ai_params()
		{return m_ai_params;}
	std::string get_Beschreibung()
		{return m_Beschreibung;}
	std::string get_Title()
		{return m_title;}
	std::string getPlayerShip()
		{return m_PShip;}
	std::string getBosPlaylist()
		{return m_playlist[1];}
	std::string getNormalPlaylist()
		{return m_playlist[0];}
	std::string getImage()
		{return m_image;}
	int getFramecount()
		{return m_framecount;}
	int getFramedelay()
		{return m_framedelay;}
};

#endif

