/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//MenuListField.h - Deklaration der Klasse CMenuListField
//CMenuListField wird für das Verwalten und Darstellen von Listenfeldern benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef MENULISTFIELD_H
#define MENULISTFIELD_H

#include "Bitmapfont.hpp"
#include <vector>
#include <string>
#include <cstdio>
#include <SFML/Graphics.hpp>

static const unsigned MENU_DISPLAY_COUNT = 13;

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Liste für die Menüs
  * \author Steffen Nörtershäuser
  */
class CMenuListField
{
public:
	//Konstruktor und Destruktor
	CMenuListField();
	~CMenuListField();

	//Diese Funktion intialisiert das Listenfeld
	void Init(CBitmapFont* BitMapFont, std::string ListSelectionName);

	//Diese Funktion fügt einen Eintrag zum Listenfeld hinzu
	void AddEntry(std::string Entry) { m_Entrys.push_back(Entry); }

	//Diese Funktion legt die Position fest
	void SetPosition(float X, float Y)
	{
		m_X = X;
		m_Y = Y;
	}

	//Diese Funktion gibt die Position des Listenfeldes zurück
	float GetXPosition() const { return m_X; }
	float GetYPosition() const { return m_Y; }


	//Diese Funktion legt die Größe des Listenfeldes zurück
	void SetSize(float SizeX, float SizeY)
	{
		m_SizeX = SizeX;
		m_SizeY = SizeY;
	}

	//Diese FUnktion gibt die Größe des Listenfeldes zurück
	float GetXSize() { return m_SizeX; }
	float GetYSize() { return m_SizeY; }

	//Diese Funktion selektiert den angebne Eintrag
	void SelectEntryWithScroll(std::size_t Index)
	{
		if(m_Scroll + Index >= m_Entrys.size())
		{
			return;
		}

		m_CurSel = m_Scroll + Index;
	}

	//Diese Funktion selektiert den angebne Eintrag
	void SelectEntryWithoutScroll(std::size_t Index)
	{
		if(Index >= m_Entrys.size())
		{
			return;
		}

		m_CurSel = Index;
	}

	//Diese Funktion scrollt das Listenfeld
	void Scroll(int Scroll)
	{
		if(m_Entrys.size() < MENU_DISPLAY_COUNT)
		{
			return;
		}

		m_Scroll += Scroll;

		SetScroll(m_Scroll);
	}

	//Diese Funktion legt die ScrollPosition des Listenfeldes fest
	void SetScroll(int Scroll)
	{
		if(m_Entrys.size() < MENU_DISPLAY_COUNT)
		{
			return;
		}

		m_Scroll = Scroll;

		if(m_Scroll < 0)
		{
			m_Scroll = 0;
		}

		if(m_Scroll + MENU_DISPLAY_COUNT + 1 > m_Entrys.size())
		{
			m_Scroll = m_Entrys.size() - MENU_DISPLAY_COUNT - 1;
		}
	}

	//Diese Funktion gibt zurück ob hoch gescrollt werden kann
	bool CanScrollUp() const
	{
		return (m_Scroll > 0);
	}

	//Diese Funktion gibt zurück ob runter gescrollt werden kann
	bool CanScrollDown() const
	{
		if(m_Scroll + MENU_DISPLAY_COUNT + 1 >= m_Entrys.size() || m_Entrys.size() < MENU_DISPLAY_COUNT)
		{
			return false;
		}

		return true;
	}

	//Diese Funktion gibt den momentan ausgewählten Eintrag zurück
	std::string GetCurEntry() const { return m_Entrys[m_CurSel]; }

	//Diese Funktion gibt den momentan ausgewählten Eintrag zurück
	std::string GetEntry(std::size_t Index) const
	{ 
		if(Index >= m_Entrys.size())
		{
			return "";
		}

		return m_Entrys[Index]; 
	}


	//Diese Funktion gibt den mometan ausgewählten Index zurück
	int GetCurSelectIndex() const { return m_CurSel; }

	//Diese Funktion zeichnet das Listenfeld
	void Draw();


	//Diese Funktion löscht alle Einträge
	void Clear()
	{
		m_Entrys.clear();
		m_CurSel = 0;
		m_Scroll = 0;
	}

	//Diese Funktion gibt die Anzahl der Einträge zurück
	std::size_t GetEntryCount() const { return m_Entrys.size(); }
private:
	sf::Sprite	m_ListSelectionSprite;  //Das Sprite wird hinter das mometan ausgewählt mit Alpha gezeichnet

	CBitmapFont* m_BitMapFont;	//Der BitMapFont

	std::vector<std::string> m_Entrys;	//Die Einträge
	std::size_t m_CurSel;				//Was momentan ausgewählt ist
	int m_Scroll;				//Um wieviel Einträge gescrollt wurde

	float m_X;					//Die X-Position des Listenfeld
	float m_Y;					//Die Y-Position des Listenfeld

	float m_SizeX;				//Die X-Breite des Listenfeldes
	float m_SizeY;				//Die Y-Breite des Listenfeldes	
};
#endif

