/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MenuListField.hpp"
#include "Singletons.hpp"

CMenuListField::CMenuListField()
		: m_BitMapFont(NULL),
		  m_CurSel(0),
		  m_Scroll(0),
		  m_X(0),
		  m_Y(0),
		  m_SizeX(0),
		  m_SizeY(0)
{}

CMenuListField::~CMenuListField()
{}

void CMenuListField::Init(CBitmapFont* BitMapFont, std::string ListSelectionName)
{
	m_BitMapFont = BitMapFont;

	m_ListSelectionSprite.SetImage(sgl::get_imagemgr().get_img(ListSelectionName));
	m_ListSelectionSprite.SetColor(sf::Color(255,255,255,128));
}

void CMenuListField::Draw()
{
	if(m_BitMapFont == NULL)
	{
		return;
	}

	std::size_t CurIndex = 0;

	for(std::size_t CurEntry = m_Scroll; CurEntry < m_Entrys.size(); CurEntry++)
	{
		if(CurEntry == m_CurSel)
		{
			m_ListSelectionSprite.SetPosition(m_X + 20,m_Y + (CurEntry - m_Scroll) * 32 + 10);
			sgl::get_window().Draw(m_ListSelectionSprite);
		}

		if(m_Entrys[CurEntry].length() * 25 < m_X + m_SizeX)
		{
			m_BitMapFont->DrawText(m_X + 20,m_Y + (CurEntry - m_Scroll) * 32 + 10, m_Entrys[CurEntry]);
		}
		else
		{
			m_BitMapFont->DrawText(m_X + 20,m_Y + (CurEntry - m_Scroll) * 32 + 10, m_Entrys[CurEntry].substr(0,m_SizeX / 32 - 2)+"...");
		}

		CurIndex++;

		if(CurIndex > MENU_DISPLAY_COUNT)
		{
			break;
		}
	}
}
