/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2007,2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Mathfuncs.h - Stellt einige Mathematische Funktionen bereit
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef MATHFUNCS_H
#define MATHFUNCS_H

#include <cstdlib>
#include <cmath>
//////////////////////////////////////////////////////////////////////////////////////////////////


/// Diese Funktion berechnet die 2 Potenz mit dem angeben Exponenten
inline int GetPow2(int Exp)
{
	return (1 << Exp);
}

/// Diese Funktion berechnet die nächst größte 2er Potzen nach dem angeben wert
inline int GetBiggerPow2(int Value)
{
	if (Value < 1) return 0;
	int i = 1;

	while (Value >> i)
	{
		i++;	
	}

	return GetPow2(i);
}

/// Diese Funktion interpoliert linear zwischen den beiden Werten
inline float lerp(float Value1, float Value2, float a)
{
	return(Value1*(1.0f-a)+Value2*a);
}

/// Diese Funktion gibt eine Zufallszahl zwischen den beiden angeben Werten zurück
inline float frnd(float low, float high)
{
	if(low > high)
	{
		float Temp = high;
		high = low;
		low = Temp;
	}

	float rnd = low + (high - low) * ( (long)rand() ) / RAND_MAX;

	if(rnd < high)
	{
		return rnd;
	}
	else
	{
		return low;
	}
}

/// Signumsfunktion
inline int sgn(float arg)
{
	return (arg < 0.0f) ? -1 : 1;
}

//Deise Funktion berechnet die Manhattan-Distanz (Näherung für den Abstand)
inline float manhattan(float x1, float y1, float x2, float y2)
{
	return std::fabs(x1-x2) + std::fabs(y1-y2);
}

#endif 

