/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Kampagne.hpp"

#include <boost/format.hpp>

#include <libintl.h>
#define _(string) gettext(string)

std::size_t CKampagne::get_MissionIndex()
{
	std::size_t result = 0;
	std::list<CMission*>::iterator tmp = m_Missions.begin();

	while (tmp != m_ActualMission)
	{
		if(tmp == m_Missions.end())
		{
			return 0;
		}
		else
		{
			tmp++;
			result++;
		}
	}
	return result;
}

bool CKampagne::set_MissionIndex(int index)
{
	std::list<CMission*>::iterator tmp = m_Missions.begin();
	while(index--)
	{
		tmp++;
		if (tmp == m_Missions.end())
		{
			LOG4CXX_ERROR(log_, _("Invalid Index"));
			return false;
		}
	}
	m_ActualMission = tmp;
	return true;
}

void CKampagne::clearMissions()
{
	if (m_Missions.size() == 0) return;
	std::list<CMission*>::iterator tmp = m_Missions.begin();
	while (tmp != m_Missions.end())
	{
		delete (*tmp);
		m_Missions.erase(tmp++);
	}
}

bool CKampagne::init(std::string filename)
{
	LOG4CXX_DEBUG(log_, boost::format(_("Reading CKampagne %1%")) % filename);
	clearMissions();
	errorCode result = readFile(filename);

	if (m_Missions.size() == 0) LOG4CXX_ERROR(log_, _("No Mission found"));
	m_ActualMission = m_Missions.begin();



	switch (result)
	{
		case FAILED_OPEN:
			LOG4CXX_ERROR(log_, boost::format(_("Error while opening File %1%!")) % filename);
			break;
		case WRONG_SYNTAX:
			LOG4CXX_ERROR(log_, boost::format(_("invalid Syntax in File %1%!")) % filename);
			break;
		case MISSING_ATTRIBUTE:
			LOG4CXX_ERROR(log_, boost::format(_("Missing Attributes in File %1%!")) % filename);
			break;
	}
	
	LOG4CXX_DEBUG(log_, boost::format(_("%1% Missions loaded"))%m_Missions.size());

	return (result == SUCCESS);
}

bool CKampagne::nextMission()
{
	LOG4CXX_DEBUG(log_, _("Starting New Mission"));
	if (++m_ActualMission == m_Missions.end())
		return false;
	else 
		return true;
}

errorCode CKampagne::readFile(std::string filename)
{
	char buffer[255];

	std::string Buffer;
	std::string Tag;
	std::string enemy_file_wave;
	std::string enemy_file_params;
	std::string Beschreibung;
	std::string Titel;
	std::string PShip;
	std::string image;
	int framecount;
	int framedelay;
	std::string playlist[2];

	FILE* theFile = fopen(filename.c_str(),"r");

	if(theFile == NULL)
	{
		return FAILED_OPEN;
	}

	while(std::feof(theFile) == 0)
	{
		std::fscanf(theFile, "%s", buffer);

		Buffer = buffer;

		if (Buffer == "<intro>")
		{
			while(1)
			{
				if(std::feof(theFile) != 0)
					return UNEXPECTED_ENDING;

				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
				if(Buffer != "</intro>")
				{
					m_Intro += " ";
					m_Intro += Buffer;
				}
				else
					break;
			}
		}
		else if (Buffer == "<img>")
		{
			std::fscanf(theFile, "%s", buffer);
			m_ImgFile = buffer;
			std::fscanf(theFile, "%s", buffer);
			Buffer = buffer;
			if (Buffer != "</img>")
			{
				return WRONG_SYNTAX;
			}
		}
		else if (Buffer == "<framecount>")
		{
			std::fscanf(theFile, "%d", &m_framecount);
			std::fscanf(theFile, "%s", buffer);
			Buffer = buffer;
			if (Buffer != "</framecount>")
			{
				return WRONG_SYNTAX;
			}
		}
		else if (Buffer == "<framedelay>")
		{
			std::fscanf(theFile, "%d", &m_framedelay);
			std::fscanf(theFile, "%s", buffer);
			Buffer = buffer;
			if (Buffer != "</framedelay>")
			{
				return WRONG_SYNTAX;
			}
		}
		else if (Buffer == "<leben>")
		{
			std::fscanf(theFile, "%d", &m_leben);
			std::fscanf(theFile, "%s", buffer);
			Buffer = buffer;
			if (Buffer != "</leben>")
			{
				return WRONG_SYNTAX;
			}
		}
		else if (Buffer == "<title>")
		{
			while(1)
			{
				if(feof(theFile) != 0)
					return UNEXPECTED_ENDING;

				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
				if(Buffer != "</title>")
				{
					m_Title += " ";
					m_Title += Buffer;
				}
				else
					break;
			}
		}
		else if (Buffer == "<epilog>")
		{
			while(1)
			{
				if(std::feof(theFile) != 0)
					return UNEXPECTED_ENDING;

				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
				if(Buffer != "</epilog>")
				{
					m_Epilog += " ";
					m_Epilog += Buffer;
				}
				else
					break;
			}				
		}
		else if (Buffer == "<niederlage>")
		{
			while(1)
			{
				if(std::feof(theFile) != 0)
					return UNEXPECTED_ENDING;

				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
				if(Buffer != "</niederlage>")
				{
					m_Niederlage += " ";
					m_Niederlage += Buffer;
				}
				else
					break;
			}				
		}
		else if (Buffer == "<mission>")
		{
			Beschreibung = "";
			enemy_file_wave = "";
			enemy_file_params = "";
			Titel = "";
			image = "";
			framecount = 1;
			framedelay = 10;
			while (std::fscanf(theFile, "%s", buffer))
			{
				Buffer = buffer;
						
				if (Buffer == "</mission>") break;

				if (Buffer == "<ai>")
				{
					while (Buffer != "</ai>")
					{
						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;

						if (Buffer == "<wavefile>")
						{
							std::fscanf(theFile, "%s", buffer);
							enemy_file_wave = buffer;
							std::fscanf(theFile, "%s", buffer);
							Tag = buffer;
							if (Tag != "</wavefile>")
							{
								std::printf("1!");
								return WRONG_SYNTAX;
							}
						}
						else if (Buffer == "<parameterfile>")
						{
							std::fscanf(theFile, "%s", buffer);
							enemy_file_params = buffer;
							std::fscanf(theFile, "%s", buffer);
							Tag = buffer;
							if (Tag != "</parameterfile>")
							{
								std::printf("2!");
								return WRONG_SYNTAX;
							}
						}
						if(std::feof(theFile) != 0)
							return UNEXPECTED_ENDING;
					}
				}
				else if (Buffer == "<playlist>")
				{
					while (Buffer != "</playlist>")
					{
						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;

						if (Buffer == "<boss>")
						{
							std::fscanf(theFile, "%s", buffer);
							playlist[1] = buffer;
							std::fscanf(theFile, "%s", buffer);
							Tag = buffer;
							if (Tag != "</boss>")
							{
								std::printf("1!");
								return WRONG_SYNTAX;
							}
						}
						else if (Buffer == "<normal>")
						{
							std::fscanf(theFile, "%s", buffer);
							playlist[0] = buffer;
							std::fscanf(theFile, "%s", buffer);
							Tag = buffer;
							if (Tag != "</normal>")
							{
								std::printf("2!");
								return WRONG_SYNTAX;
							}
						}
						if(feof(theFile) != 0)
							return UNEXPECTED_ENDING;
					}
				}
				else if (Buffer == "<deskription>")
				{
					while(1)
					{
						if(std::feof(theFile) != 0)
							return UNEXPECTED_ENDING;

						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;
						if(Buffer != "</deskription>")
						{
							Beschreibung += " ";
							Beschreibung += Buffer;
						}
						else
							break;
					}				
				}
				else if (Buffer == "<title>")
				{
					while(1)
					{
						if(std::feof(theFile) != 0)
							return UNEXPECTED_ENDING;

						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;
						if(Buffer != "</title>")
						{
							Titel += " ";
							Titel += Buffer;
						}
						else
							break;
					}				
				}
				else if (Buffer == "<playership>")
				{
					std::fscanf(theFile, "%s", buffer);
					PShip = buffer;
					std::fscanf(theFile, "%s", buffer);
					Buffer = buffer;
					if (Buffer != "</playership>")
					{
						return WRONG_SYNTAX;
					}
				}
				else if (Buffer == "<img>")
				{
					std::fscanf(theFile, "%s", buffer);
					image = buffer;
					std::fscanf(theFile, "%s", buffer);
					Buffer = buffer;
					if (Buffer != "</img>")
					{
						return WRONG_SYNTAX;
					}
				}
				else if (Buffer == "<framecount>")
				{
					std::fscanf(theFile, "%d", &framecount);
					std::fscanf(theFile, "%s", buffer);
					Buffer = buffer;
					if (Buffer != "</framecount>")
					{
						return WRONG_SYNTAX;
					}
				}
				else if (Buffer == "<framedelay>")
				{
					std::fscanf(theFile, "%d", &framedelay);
					std::fscanf(theFile, "%s", buffer);
					Buffer = buffer;
					if (Buffer != "</framedelay>")
					{
						return WRONG_SYNTAX;
					}
				}
				else if (Buffer == "<!--")
				{
					do
					{
						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;
					}
					while(Buffer != "-->");							
				}
			}
					
			if (Buffer != "</mission>")
			{
				std::printf("3!");
				return WRONG_SYNTAX;
			}
			if (enemy_file_wave != "" && enemy_file_params != "")
			{
				m_Missions.push_back(new CMission(enemy_file_wave, enemy_file_params, Beschreibung, Titel, PShip, playlist, image, framecount, framedelay));
			}
			else
				return MISSING_ATTRIBUTE;
		}
		else if (Buffer == "<!--")
		{
			do
			{
				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
			}
			while(Buffer != "-->");
		}
		else if (Buffer == "</mission>")
		{
			LOG4CXX_DEBUG(log_, boost::format(_("Superstitous </mission>")) % filename);
		}
		else
		{
			LOG4CXX_ERROR(log_, Buffer);
			LOG4CXX_ERROR(log_, boost::format("%1% %2% %3% %4% %5%") % m_Intro % m_ImgFile % m_Epilog % m_Niederlage % m_Title);
			return WRONG_SYNTAX;
		}
	}
	std::fclose(theFile);
	return SUCCESS;

}
