/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef IMAGES_HPP_INCLUDED
#define IMAGES_HPP_INCLUDED

#include <SFML/Graphics.hpp>

#include <map>
#include <string>

/** \brief Image Loader
  * \author Christoph Egger
  */
class ImageMgr
{
	public:
		const sf::Image& get_img(const std::string& name)
		{
			if (images.find(name) != images.end())
				return images[name];
			else
			{
				images[name] = sf::Image();
				images[name].LoadFromFile(name);
				return images[name];
			}
		}
		void clear() {images.clear();}
	private:
		std::map<std::string,sf::Image> images;
};

#endif

