/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HUDMANAGER_H
#define HUDMANAGER_H

#include <string>
#include <list>

#include <SFML/Graphics.hpp>

#include "HUD-Element.hpp"
#include "Enemy_Help.hpp"
#include "Bitmapfont.hpp"

#include "Player.hpp"
#include "Ship.hpp"


/** \brief Verwaltung der HUDs
  * \author Christoph Egger
  */
class CHUDManager
{
	std::list<AHUDElement*> m_Elemente;
	global_data_pointers m_data;
	sf::Sprite* m_Background;
public:
	CHUDManager(){m_Background = new sf::Sprite;}
	void init(global_data_pointers pointers, CBitmapFont* bmFont);
	AHUDElement* registerHUD(int maxValue, const int* ActualValue, HUDType Type, int posX, int posY, int width, int height, int size = 15);
	AHUDElement* registerHUD(float maxValue, const float* ActualValue, HUDType Type, int posX, int posY, int width, int height, int size = 15);
	AHUDElement* registerHUD(const std::string* data, HUDType Type,  int posX, int posY, CBitmapFont* bmFont, int fontsize = 15, int size = 138);
	std::string* registerHUD(int posX, int posY, CBitmapFont* bmFont, HUDType Type = SET_TEXT, int size = 15);
	AHUDElement* registerHUD(bool* play_Info, std::list<SInfo*>* Infos, CBitmapFont* bmFont);
	void draw();
	~CHUDManager();
};

#endif
